﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MathTextBox
{
    public class MathTextManager
    {
        protected Int32 index;
        protected MathTextCell textView;
        protected TextBoxY activeTextBox;
        protected List<SubordinateCell> cells = new List<SubordinateCell>();
        protected Boolean isActive;
        protected Control parent;

        


        public MathTextManager(MathTextCell textview)
        {
            this.Cells.Add(new SubordinateCell("0,0", " "));
            TextView = textview;
            int w = 0, h = 0;
            MathTextCell.SelectedTextBoxIndex = "0,0";
            MathTextCell.SelectedTextBoxCaretIndex = 0;
            TextView.setExpression(Cells, this, 0,ref w,ref h);
            
            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Focus();
                ActiveTextBox = MathTextCell.SelectedTextBox;
                IsActive = true;
            }
        }
        public MathTextManager()
        {
            this.Cells.Add(new SubordinateCell("0,0", " "));
            
        }
        public MathTextManager(MathTextCell textview, List<SubordinateCell> LSC)
        {
            this.Cells.AddRange(LSC);
            TextView = textview;
            int w = 0, h = 0;
            MathTextCell.SelectedTextBoxIndex = "0,0";
            MathTextCell.SelectedTextBoxCaretIndex = 0;
            TextView.setExpression(Cells, this, 0, ref w, ref h);
            
            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Focus();
                ActiveTextBox = MathTextCell.SelectedTextBox;
                IsActive = true;
            }
        }

        public MathTextCell TextView
        {
            set
            {
                textView = value;
            }
            get
            {
                return textView;
            }
        }

        public Int32 Index
        {
            set
            {
                index = value;
            }
            get
            {
                return index;
            }
        }
        public TextBoxY ActiveTextBox
        {
            set
            {
                activeTextBox = value;
            }
            get
            {
                return activeTextBox;
            }
        }

        public List<SubordinateCell> Cells
        {
            get
            {
                return cells;
            }
            set
            {
                cells = value;
            }
        }

        public Boolean IsActive
        {
            set
            {
                isActive = value;
            }
            get
            {
                return isActive;
            }
        }
        public Control Parent
        {
            set
            {
                parent = value;
            }
            get
            {
                return parent;
            }
        }
        public void TBY_KeyDown(object sender, KeyEventArgs e)
        {
            bool effect = true;
            e.Handled = true;
            if (e.KeyData == Keys.Enter)
            {
                if (ActiveTextBox.Text == "" && Cells.Count == 1)
                {
                    foreach (SubordinateCell S in Cells)
                    {
                        if (S.Index == ActiveTextBox.Tag.ToString())
                        {
                            S.Text = "";
                            
                            ((MathStatment)Parent).AddNewCell();
                            effect=false;
                            break;
                        }
                    }
                }
                else
                {
                    effect=false;
                    ((MathStatment)Parent).AddNewCell();
                    
                }

                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);
                
            }
            else if(e.KeyData == Keys.Back)
            {
                onCE();
            }
            e.Handled = !effect;

            
            ((MathStatment)Parent).onAnsweChanged();
        }
        public void TBY_Enter(object sender, EventArgs e)
        {

            ((MathStatment)Parent).IAmActive(Index);
            
            ActiveTextBox = (TextBoxY)sender;
            ((MathStatment)Parent).onFocusedItemChanged();
            MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
            MathTextCell.SelectedTextBoxCaretIndex = ActiveTextBox.CaretIndex;
        }
        public void TBY_Leave(object sender, EventArgs e)
        {
            
        }
        public void TBY_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
            
            

            if (e.KeyChar == '/' || e.KeyChar == '*' || e.KeyChar == '+' || e.KeyChar == '-')
            {
                 onOperator(e.KeyChar);
                
               
            }
            else if(e.KeyChar == ';')
            {
                

                if (ActiveTextBox.Text== "" && Cells.Count==1)
                {
                    foreach (SubordinateCell S in Cells)
                    {
                        if(S.Index == ActiveTextBox.Tag.ToString())
                        {
                            S.Text = "";
                            MathTextCell.SelectedTextBoxCaretIndex = 3;
                            
                            

                            ((MathStatment)Parent).AddNewCell();
                            
                            break;
                        }
                    }
                }
                else
                {
                    ((MathStatment)Parent).AddNewCell();
                    
                }
                
            }
            else if ((e.KeyChar <= (char)Keys.Z && e.KeyChar >= (char)Keys.A) || (e.KeyChar <= (char)122 && e.KeyChar >= (char)97))
            {


                setText2(e.KeyChar.ToString());


            }
            else if(e.KeyChar >= '0' && e.KeyChar <= '9')
            {


                setText(e.KeyChar.ToString());



            }


            

            ((MathStatment)Parent).onAnsweChanged();
        }
        public void setText2(string chr)
        {
            int j1 = 0;
            string indx = "";
            string text = ""; 
            for (j1 = 0; j1 < Cells.Count; j1++)
            {
                if (Cells[j1].Index == ActiveTextBox.Tag.ToString())
                {
                    text = Cells[j1].Text;
                    indx = Cells[j1].Index;
                    break;
                }
            }
            if (text == "+" || text == "-" || text == "/" || text == "*")
            {
                string I = AddToIndex(indx, 1);
                InsertCell(I, chr);

                MathTextCell.SelectedTextBoxIndex = I;
                MathTextCell.SelectedTextBoxCaretIndex = chr.Length;
                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }


            ((MathStatment)Parent).onAnsweChanged();
            }
            else if (ActiveTextBox.TextMode == TextBoxY.TextModeType.Number)
            {
                ActiveTextBox.CaretIndex = ActiveTextBox.Text.Length;
                onOperator('*');
                MathTextCell.SelectedTextBoxCaretIndex = 1;
                MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
                MathTextCell.SelectedTextBoxCaretIndex = ActiveTextBox.CaretIndex + chr.Length;
                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }

                setText2(chr);

            ((MathStatment)Parent).onAnsweChanged();




            }
            
            else if(!isFunction(text) && !(text == "()") && (isVarible(text) || text == " "))
            {
                MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
                MathTextCell.SelectedTextBoxCaretIndex = 1;
                for (int i = 0; i < Cells.Count; i++)
                {
                    if (Cells[i].Index == ActiveTextBox.Tag.ToString())
                    {
                        Cells[i].Text = ActiveTextBox.Text;
                        Cells[i].Text = Cells[i].Text.Insert(ActiveTextBox.CaretIndex, chr);
                    }
                }
                MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
                MathTextCell.SelectedTextBoxCaretIndex = ActiveTextBox.CaretIndex + chr.Length;
                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }

            ((MathStatment)Parent).onAnsweChanged();
            }



            
        }
        public void setText(string chr)
        {

            int j1 = 0;
            string text = "";
            string indx = "";
            for (j1 = 0; j1 < Cells.Count; j1++)
            {
                if (Cells[j1].Index == ActiveTextBox.Tag.ToString())
                {
                    text = Cells[j1].Text;
                    indx = Cells[j1].Index;
                    break;
                }
            }
            if (!isFunction(text) && !(text == "()") && isVarible(text) && text != " ")
            {
                ActiveTextBox.CaretIndex = ActiveTextBox.Text.Length;
                onOperator('*');
                MathTextCell.SelectedTextBoxCaretIndex = 1;
                MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
                for (int i = 0; i < Cells.Count; i++)
                {
                    if (Cells[i].Index == ActiveTextBox.Tag.ToString())
                    {
                        Cells[i].Text = ActiveTextBox.Text;
                        Cells[i].Text = Cells[i].Text.Insert(ActiveTextBox.CaretIndex, chr);
                    }
                }
                MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
                MathTextCell.SelectedTextBoxCaretIndex = ActiveTextBox.CaretIndex + chr.Length;
                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }


            ((MathStatment)Parent).onAnsweChanged();



            }
            else if(text == "+" || text == "-" || text == "/" || text == "*")
            {
                string I = AddToIndex(indx, 1);
                InsertCell(I, chr);

                MathTextCell.SelectedTextBoxIndex =I;
                MathTextCell.SelectedTextBoxCaretIndex = chr.Length;
                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }


            ((MathStatment)Parent).onAnsweChanged();
            }
            else if(ActiveTextBox.TextMode == TextBoxY.TextModeType.Number || text == " ")
            {
                MathTextCell.SelectedTextBoxCaretIndex++;
                MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
                for (int i = 0; i < Cells.Count; i++)
                {
                    if (Cells[i].Index == ActiveTextBox.Tag.ToString())
                    {
                        Cells[i].Text = ActiveTextBox.Text;
                        Cells[i].Text = Cells[i].Text.Insert(ActiveTextBox.CaretIndex, chr);
                    }
                }
                MathTextCell.SelectedTextBoxIndex = ActiveTextBox.Tag.ToString();
                MathTextCell.SelectedTextBoxCaretIndex = ActiveTextBox.CaretIndex + chr.Length;
                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }


            ((MathStatment)Parent).onAnsweChanged();



            }
            
        }

        public void onClear()
        {

            Cells.Clear();
            Cells.Add(new SubordinateCell("0,0", " "));

            MathTextCell.SelectedTextBoxIndex = "0,0";
            MathTextCell.SelectedTextBoxCaretIndex = 0;
            int w = 0, h = 0;
            TextView.setExpression(Cells,this, 0, ref w, ref h);

            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Focus();

            }

            ((MathStatment)Parent).onAnsweChanged();

        }

        public void onCE()
        {
            int crtIndex = ActiveTextBox.CaretIndex;
            string tag = ActiveTextBox.Tag.ToString();
            string text ="";
            string activeText = ActiveTextBox.Text;
            int i = 0;
            for(i = 0; i<Cells.Count;i++ )
            {
                if(Cells[i].Index== tag)
                {
                    text = Cells[i].Text;
                    break;
                }
            }
            if (text == "")
                return;
            if (!isFunction(text) && !(text == "()") && !(text == "{}") && !(text == ""))
            {
                if (text != " ")
                {
                    Cells[i].Text = Cells[i].Text.Remove(crtIndex - 1, 1);

                    Cells[i].Text = (Cells[i].Text == "" ? " " : Cells[i].Text);
                    MathTextCell.SelectedTextBoxIndex = tag;
                    MathTextCell.SelectedTextBoxCaretIndex = crtIndex - 1;
                    int w = 0, h = 0;
                    TextView.setExpression(Cells, this, 0, ref w, ref h);

                    if (MathTextCell.SelectedTextBox != null)
                    {
                        MathTextCell.SelectedTextBox.Select();

                    }
                }
                else
                {
                    if(Cells[i].Index != "0,0")
                    {
                        RemoveCell(Cells[i].Index);
                        if (i > 0)
                        {
                            MathTextCell.SelectedTextBoxIndex = Cells[i - 1].Index;
                            MathTextCell.SelectedTextBoxCaretIndex = Cells[i - 1].Text.Length;
                            int w = 0, h = 0;
                            TextView.setExpression(Cells, this, 0, ref w, ref h);

                            if (MathTextCell.SelectedTextBox != null)
                            {
                                MathTextCell.SelectedTextBox.Select();

                            }
                        }
                    }
                }
            }

            ((MathStatment)Parent).onAnsweChanged();
        }

        public void onSParanthes()
        {
            string text = "";
            string tag1 = ActiveTextBox.Tag.ToString();
            int j1 = 0;
            for (j1 = 0; j1 < Cells.Count; j1++)
            {
                if (Cells[j1].Index == tag1)
                {
                    text = Cells[j1].Text;
                    break;
                }
            }

            int crtIndex = ActiveTextBox.CaretIndex;
            string part1 = ActiveTextBox.Text.Substring(0, crtIndex);
            string part2 = ActiveTextBox.Text.Substring(crtIndex);
            part1 = (part1 == "" ? " " : part1);
            part2 = (part2 == "" ? " " : part2);
            string tag = ActiveTextBox.Tag.ToString();
            //RemoveCell(tag);
            //InsertCell(tag, part1);
            string tagWithoutLast = (tag.IndexOf(',') == -1 ? "" : tag.Remove(tag.LastIndexOf(',')));



            if ((isFunction(text)) || (text == "()") || (text == "{}") || (text == ""))
            {
                onOperator('*');
            }
            else if (isVarible(text))
            {
                
                RemoveCell(tag);

                InsertCell(tag + ",0", text + "()");

                InsertCell( tag + (tag == "" ? "" : ",") + "1,0"," ") ;
                





                MathTextCell.SelectedTextBoxIndex = tag + ",1,0";
                MathTextCell.SelectedTextBoxCaretIndex = 0;
                int w1 = 0, h1 = 0;
                TextView.setExpression(Cells, this, 0, ref w1, ref h1);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }

            ((MathStatment)Parent).onAnsweChanged();


                return;
            }

           

            

            InsertCell(tag + ",0", "()");

            
            //tag = AddToIndex(tag, 1);


            foreach (SubordinateCell SC in Cells)
            {
                
                if (SC.Index.StartsWith(tagWithoutLast) )
                {
                    string T = "";
                    if (tagWithoutLast == "")
                        T = tag;
                    else
                        T = tag.Substring(tagWithoutLast.Length + 1);

                    

                    int j = tag.Split(',').Length  -1 ;

                    T = (T.IndexOf(',') == -1 ? T : T.Remove(T.IndexOf(',')));
                   
                    int i = Convert.ToInt32(T);

                    string nth = theNthIndex(IndexWithIndex(SC.Index), j);

                    string tagTheLast = theLastIndex(tag);

                    if (nth != "" && Convert.ToInt32(nth) > i)
                    {
                        string T1 = AddToIndex(SC.Index,j,-Convert.ToInt32(tagTheLast) - 1);
                        


                        if (tagWithoutLast== "")
                        { }
                        else
                            T1 = T1.Substring(tagWithoutLast.Length + 1);

                        

                        SC.Index = tag + (tag == "" ? "" : ",") + "1," + T1;
                    }
                }
            }


            

            //InsertCell(tag + ",1,0", part2);

            MathTextCell.SelectedTextBoxIndex = tag + ",1,0";
            MathTextCell.SelectedTextBoxCaretIndex = 0;
            int w = 0, h = 0;
            TextView.setExpression(Cells, this, 0, ref w, ref h);

            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Select();

            }

            ((MathStatment)Parent).onAnsweChanged();
        }

        public void comma()
        {
            int i = 0;
            string tag1 = ActiveTextBox.Tag.ToString();
            for (i = 0; i < Cells.Count; i++)
            {
                if (Cells[i].Index == tag1)
                {
                    break;
                }
            }
            for (;i>=0;i--)
            {
                if (isFunction(Cells[i].Text))
                {
                    int k = 0;
                    string tagwithoutLast = Cells[i].Index.Remove(Cells[i].Index.LastIndexOf(','));
                    foreach (SubordinateCell SC in Cells)
                    {
                        int j = tagwithoutLast.Split(',').Length;
                        if (SC.Index.StartsWith(tagwithoutLast))
                        {
                            int t = Convert.ToInt32(theNthIndex(IndexWithIndex(SC.Index), j));
                            if (t > k) k = t;
                        }
                    }
                    k++;
                    string ind = tagwithoutLast + "," + k.ToString();
                    InsertCell(ind, " ");

                    MathTextCell.SelectedTextBoxIndex = ind;
                    MathTextCell.SelectedTextBoxCaretIndex = 0;
                    int w = 0, h = 0;
                    TextView.setExpression(Cells, this, 0, ref w, ref h);

                    if (MathTextCell.SelectedTextBox != null)
                    {
                        MathTextCell.SelectedTextBox.Select();

                    }

                    ((MathStatment)Parent).onAnsweChanged();

                    break;

                }
            }
        }

        public void onFunction1Arc(String name)
        {

            string text = "";
            string tag1 = ActiveTextBox.Tag.ToString();
            int j1 = 0;
            for (j1 = 0; j1 < Cells.Count; j1++)
            {
                if (Cells[j1].Index == tag1)
                {
                    text = Cells[j1].Text;
                    break;
                }
            }
            if ((isFunction(text)) || (text == "()") || (text == "{}") || (text == ""))
            {
                onOperator('*');
            }


            int crtIndex = ActiveTextBox.CaretIndex;
            string part1 = ActiveTextBox.Text.Substring(0, crtIndex);
            string part2 = ActiveTextBox.Text.Substring(crtIndex);
            part1 = (part1 == "" ? " " : part1);
            part2 = (part2 == "" ? " " : part2);
            string tag = ActiveTextBox.Tag.ToString();
            string tagWithoutLast = (tag.IndexOf(',') == -1 ? "" : tag.Remove(tag.LastIndexOf(',')));



            InsertCell(tag + ",0",name + "()");


            //tag = AddToIndex(tag, 1);


            foreach (SubordinateCell SC in Cells)
            {
                
                if (SC.Index.StartsWith(tagWithoutLast))
                {
                    string T = "";
                    if (tagWithoutLast == "")
                        T = tag;
                    else
                        T = tag.Substring(tagWithoutLast.Length + 1);

                    

                    int j = tag.Split(',').Length - 1;

                    T = (T.IndexOf(',') == -1 ? T : T.Remove(T.IndexOf(',')));

                    int i = Convert.ToInt32(T);

                    string nth = theNthIndex(IndexWithIndex(SC.Index), j);

                    string tagTheLast = theLastIndex(tag);

                    if (nth != "" && Convert.ToInt32(nth) > i)
                    {
                        string T1 = AddToIndex(SC.Index, j, -Convert.ToInt32(tagTheLast) - 1);



                        if (tagWithoutLast == "")
                        { }
                        else
                            T1 = T1.Substring(tagWithoutLast.Length + 1);



                        SC.Index = tag + (tag == "" ? "" : ",") + "1," + T1;
                    }
                }
            }




            //InsertCell(tag + ",1,0", part2);

            MathTextCell.SelectedTextBoxIndex = tag + ",1,0";
            MathTextCell.SelectedTextBoxCaretIndex = 0;
            int w = 0, h = 0;
            TextView.setExpression(Cells, this, 0, ref w, ref h);

            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Select();

            }

            ((MathStatment)Parent).onAnsweChanged();
        }

        public void onFunction2Arc(String name)
        {

            string text = "";
            string tag1 = ActiveTextBox.Tag.ToString();
            int j1 = 0;
            for (j1 = 0; j1 < Cells.Count; j1++)
            {
                if (Cells[j1].Index == tag1)
                {
                    text = Cells[j1].Text;
                    break;
                }
            }
            if ((isFunction(text)) || (text == "()") || (text == "{}") || (text == ""))
            {
                onOperator('*');
            }


            int crtIndex = ActiveTextBox.CaretIndex;
            string part1 = ActiveTextBox.Text.Substring(0, crtIndex);
            string part2 = ActiveTextBox.Text.Substring(crtIndex);
            part1 = (part1 == "" ? " " : part1);
            part2 = (part2 == "" ? " " : part2);
            string tag = ActiveTextBox.Tag.ToString();
            string tagWithoutLast = (tag.IndexOf(',') == -1 ? "" : tag.Remove(tag.LastIndexOf(',')));



            InsertCell(tag + ",0", name + "()");


            //tag = AddToIndex(tag, 1);


            foreach (SubordinateCell SC in Cells)
            {

                if (SC.Index.StartsWith(tagWithoutLast))
                {
                    string T = "";
                    if (tagWithoutLast == "")
                        T = tag;
                    else
                        T = tag.Substring(tagWithoutLast.Length + 1);



                    int j = tag.Split(',').Length - 1;

                    T = (T.IndexOf(',') == -1 ? T : T.Remove(T.IndexOf(',')));

                    int i = Convert.ToInt32(T);

                    string nth = theNthIndex(IndexWithIndex(SC.Index), j);

                    string tagTheLast = theLastIndex(tag);

                    if (nth != "" && Convert.ToInt32(nth) > i)
                    {
                        string T1 = AddToIndex(SC.Index, j, -Convert.ToInt32(tagTheLast) - 1);



                        if (tagWithoutLast == "")
                        { }
                        else
                            T1 = T1.Substring(tagWithoutLast.Length + 1);



                        SC.Index = tag + (tag == "" ? "" : ",") + "1," + T1;
                    }
                }
                
            }

            InsertCell(tag + (tag == "" ? "" : ",") + "2,0", " ");


            //InsertCell(tag + ",1,0", part2);

            MathTextCell.SelectedTextBoxIndex = tag + ",2,0";
            MathTextCell.SelectedTextBoxCaretIndex = 0;
            int w = 0, h = 0;
            TextView.setExpression(Cells, this, 0, ref w, ref h);

            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Select();

            }

           ((MathStatment)Parent).onAnsweChanged();
        }

        public void Pow2(String name,string P)
        {

            string text = "";
            string tag1 = ActiveTextBox.Tag.ToString();
            int j1 = 0;
            for (j1 = 0; j1 < Cells.Count; j1++)
            {
                if (Cells[j1].Index == tag1)
                {
                    text = Cells[j1].Text;
                    break;
                }
            }
            if ((isFunction(text)) || (text == "()") || (text == "{}") || (text == ""))
            {
                onOperator('*');
            }


            int crtIndex = ActiveTextBox.CaretIndex;
            string part1 = ActiveTextBox.Text.Substring(0, crtIndex);
            string part2 = ActiveTextBox.Text.Substring(crtIndex);
            part1 = (part1 == "" ? " " : part1);
            part2 = (part2 == "" ? " " : part2);
            string tag = ActiveTextBox.Tag.ToString();
            string tagWithoutLast = (tag.IndexOf(',') == -1 ? "" : tag.Remove(tag.LastIndexOf(',')));



            InsertCell(tag + ",0", name + "()");


            //tag = AddToIndex(tag, 1);


            foreach (SubordinateCell SC in Cells)
            {

                if (SC.Index.StartsWith(tagWithoutLast))
                {
                    string T = "";
                    if (tagWithoutLast == "")
                        T = tag;
                    else
                        T = tag.Substring(tagWithoutLast.Length + 1);



                    int j = tag.Split(',').Length - 1;

                    T = (T.IndexOf(',') == -1 ? T : T.Remove(T.IndexOf(',')));

                    int i = Convert.ToInt32(T);

                    string nth = theNthIndex(IndexWithIndex(SC.Index), j);

                    string tagTheLast = theLastIndex(tag);

                    if (nth != "" && Convert.ToInt32(nth) > i)
                    {
                        string T1 = AddToIndex(SC.Index, j, -Convert.ToInt32(tagTheLast) - 1);



                        if (tagWithoutLast == "")
                        { }
                        else
                            T1 = T1.Substring(tagWithoutLast.Length + 1);



                        SC.Index = tag + (tag == "" ? "" : ",") + "1," + T1;
                    }
                }

            }

            InsertCell(tag + (tag == "" ? "" : ",") + "2,0", P);


            //InsertCell(tag + ",1,0", part2);

            MathTextCell.SelectedTextBoxIndex = tag + ",2,0";
            MathTextCell.SelectedTextBoxCaretIndex = 1;
            int w = 0, h = 0;
            TextView.setExpression(Cells, this, 0, ref w, ref h);

            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Select();

            }

          ((MathStatment)Parent).onAnsweChanged();
        }

        public void onLetter(string ch)
        {
            foreach(char ch1 in ch)
            {
                setText2(ch1.ToString());
            }
        }

        public void onCompareOrDefine(string s)
        {
            string indx = ActiveTextBox.Tag.ToString();
            int crtIndex = ActiveTextBox.CaretIndex;
            int itemIndex = -1;
            for (int i = 0; i < Cells.Count; i++)
            {
                if (Cells[i].Index == indx)
                {
                    itemIndex = i;
                    break;
                }
            }
            if (itemIndex == -1)
                return;

            

            int Nth = Convert.ToInt32(theNthIndex(IndexWithIndex(indx), 0));
            
            InsertCell((Nth + 1).ToString() + ",0", s);
            InsertCell((Nth + 2).ToString() + ",0", " ");

            MathTextCell.SelectedTextBoxIndex = (Nth + 2).ToString() + ",0";
            MathTextCell.SelectedTextBoxCaretIndex = 0;
            int w = 0,h = 0;
            TextView.setExpression(Cells, this, 0, ref w, ref h);

            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Select();

            }
        }
        public void onOperator(char chr)
        {

            string text = "";
            string indx = ActiveTextBox.Tag.ToString();
            string lastIndex = "";
            string indxWithoutLast = (indx.IndexOf(',') == -1 ? "" : indx.Remove(indx.LastIndexOf(',')));
            if (indx.IndexOf(',') != -1)
                lastIndex = indx.Substring(indx.LastIndexOf(',') + 1);

            int j1 = 0;
            for (j1 = 0; j1 < Cells.Count; j1++)
            {
                if (Cells[j1].Index == indx)
                {
                    text = Cells[j1].Text;
                    break;
                }
            }



            int crtIndex = ActiveTextBox.CaretIndex;
            int itemIndex = -1;
            for (int i = 0; i < Cells.Count; i++)
            {
                if (Cells[i].Index == indx)
                {
                    itemIndex = i;
                    break;
                }
            }
            if (itemIndex == -1)
                return;

            string part1 = ActiveTextBox.Text.Substring(0, crtIndex);
            string part2 = ActiveTextBox.Text.Substring(crtIndex);
            part1 = (part1 == "" ? " " : part1);
            part2 = (part2 == "" ? " " : part2);
            if (!(isFunction(text)) && !(text == "()"))
            {

                if (chr == '/')
                {
                    for (int i = 0; i < Cells.Count; i++)
                    {
                        if (Cells[i].Index == indx)
                        {
                            string I1 = Cells[i].Index + ",0,0";
                            string I2 = Cells[i].Index + ",1,0";
                            string I3 = Cells[i].Index + ",2,0";
                            RemoveCell(Cells[i].Index);
                            InsertCell(I1, part1);
                            InsertCell(I2, "/");
                            InsertCell(I3, part2);
                            MathTextCell.SelectedTextBoxIndex = I3;
                            MathTextCell.SelectedTextBoxCaretIndex = 0;
                            break;
                        }
                    }
                }
                else
                {
                    for (int i = 0; i < Cells.Count; i++)
                    {
                        if (Cells[i].Index == indx)
                        {
                            string SelectIndex = "";
                            int SelectCaret = 0;
                            int lI = Convert.ToInt32(lastIndex);
                            string I1 = indxWithoutLast + "," + lI.ToString();
                            lI++;
                            string I2 = indxWithoutLast + "," + lI.ToString();
                            lI++;
                            string I3 = indxWithoutLast + "," + lI.ToString();

                            RemoveCell(I1.ToString());


                            if (part1 != " ")
                            {
                                InsertCell(I1, part1);
                                SelectIndex = I1;
                                SelectCaret = part1.Length;
                            }
                                

                            InsertCell(I2, chr.ToString());
                            SelectIndex = I2;
                            SelectCaret = 1;

                            if (part2 != " ")
                            {
                                InsertCell(I3, part2);
                                SelectIndex = I3;
                                SelectCaret = part2.Length;
                            }

                            MathTextCell.SelectedTextBoxIndex = SelectIndex;
                            MathTextCell.SelectedTextBoxCaretIndex = SelectCaret;
                            break;
                        }
                    }

                }
            }
            else
            {
                if (chr == '/')
                {
                    for (int i = 0; i < Cells.Count; i++)
                    {
                        if (Cells[i].Index == indx)
                        {
                            string I1 = Cells[i].Index + ",0,0";



                            foreach (SubordinateCell SC in Cells)
                            {

                                if (SC.Index.StartsWith(indxWithoutLast))
                                {
                                    

                                    
                                        string T1 = SC.Index;



                                        if (indxWithoutLast == "")
                                        { }
                                        else
                                            T1 = T1.Substring(indxWithoutLast.Length + 1);



                                        SC.Index = indxWithoutLast + (indxWithoutLast == "" ? "" : ",") + "0," + T1;
                                    
                                }
                            }


                            string I2 = indxWithoutLast+ ",1,0";
                            string I3 = indxWithoutLast + ",2,0";
                            
                            InsertCell(I2, "/");
                            InsertCell(I3, " ");
                            MathTextCell.SelectedTextBoxIndex = I3;
                            MathTextCell.SelectedTextBoxCaretIndex = 0;
                            break;
                        }
                    }
                }
                else
                {
                    for (int i = 0; i < Cells.Count; i++)
                    {
                        if (Cells[i].Index == indx)
                        {
                            string SelectIndex = "";
                            int SelectCaret = 0;



                            string I = AddToIndex(indxWithoutLast, 1);

                            
                            InsertCell(I, chr.ToString());
                            SelectIndex = I;
                            SelectCaret = 1;
                            
                            MathTextCell.SelectedTextBoxIndex = SelectIndex;
                            MathTextCell.SelectedTextBoxCaretIndex = SelectCaret;
                            break;
                        }
                    }

                }
            }


            int w = 0, h = 0;
            TextView.setExpression(Cells, this, 0, ref w, ref h);

            if (MathTextCell.SelectedTextBox != null)
            {
                MathTextCell.SelectedTextBox.Select();

            }
            ((MathStatment)Parent).onAnsweChanged();
        }
        public void onRepeat()
        {
            if(ActiveTextBox.Tag.ToString() == "0,0" && ActiveTextBox.CaretIndex== 0)
            {
                InsertCell("0,0", "{}");
                int i = 0;
                for (i = 1; i < Cells.Count; i++)
                {
                    Cells[i].Index = "1," + Cells[i].Index;
                }

                MathTextCell.SelectedTextBoxIndex = Cells[(i == 0 ? i : 1)].Index;
                MathTextCell.SelectedTextBoxCaretIndex = 0;

                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }
            }
        }
        public void onEnd()
        {
            if (ActiveTextBox.Tag.ToString() == "0,0" && ActiveTextBox.CaretIndex == 0 && Cells.Count == 1)
            {
                Cells[0].Text = "";

                MathTextCell.SelectedTextBoxIndex = "0,0";
                MathTextCell.SelectedTextBoxCaretIndex = 3;

                int w = 0, h = 0;
                TextView.setExpression(Cells, this, 0, ref w, ref h);

                if (MathTextCell.SelectedTextBox != null)
                {
                    MathTextCell.SelectedTextBox.Select();

                }
            }
        }

        protected int CompareIndexes(string index1,string index2)
        {
            List<string> index1List = new List<string>();
            List<string> index2List = new List<string>();
            index1List.AddRange(index1.Split(','));
            index2List.AddRange(index2.Split(','));
            int count = Math.Max(index1List.Count,index2List.Count);

            for(int i= 0; i < count; i++)
            {
                int c1 = 0, c2 = 0;
                if(index1List.Count -1 >= i)
                {
                    c1 = Convert.ToInt32(index1List[i]);
                }
                if (index2List.Count - 1 >= i)
                {
                    c2 = Convert.ToInt32(index2List[i]);
                }
                if( c1> c2)
                {
                    return 1;
                }
                else if (c1 < c2)
                {
                    return -1;
                }
            }
            return 0;
        }

        protected void InsertCell(string indx,string text)
        {
            string Ind = indx;
            int cellPosition = -1;
            for(int i =0; i < Cells.Count; i++)
            {
                int indexCount1 = Cells[i].Index.Split(',').Length;
                List<String> indexCells = new List<String>();
                indexCells.AddRange(indx.Split(','));
                int indexCount = indexCells.Count;
                int Last = Convert.ToInt32(indexCells[indexCount - 1]);
                indexCells.RemoveAt(indexCount - 1);
                String indxWithoutLast = String.Join(",", indexCells);
                if (CompareIndexes(Cells[i].Index,Ind) == -1)
                {
                    cellPosition = i;
                }
                //
                if (indexCount1 == indexCount)
                {
                    if (Cells[i].Index == indx)
                    {
                        int last = Convert.ToInt32(theNthIndex(i, indexCount - 1));
                        if (last >= Last)
                        {
                            

                            Cells[i].Index = AddToIndex(Cells[i].Index, indexCount - 1, 1);
                            indx = Cells[i].Index;
                        }
                    }
                }
                else if(indexCount > indexCount1)
                {
                    if (indx.StartsWith(Cells[i].Index))
                    {
                        

                        Cells[i].Index = AddToIndex(Cells[i].Index, indexCount1 - 1, 1);
                        indx = Cells[i].Index;
                    }
                }
                else if (indexCount < indexCount1)
                {
                    if (Cells[i].Index.StartsWith(indx))
                    {
                       

                        Cells[i].Index = AddToIndex(Cells[i].Index, indexCount - 1, 1);
                    }
                }
            }
            cellPosition++;
            Cells.Insert(cellPosition,new SubordinateCell(Ind,text));
        }
        protected void RemoveCell(string indx)
        {
            List<String> indexCells = new List<String>();
            indexCells.AddRange(indx.Split(','));
            int indexCount = indexCells.Count;
            int Last = Convert.ToInt32(indexCells[indexCount - 1]);
            indexCells.RemoveAt(indexCount - 1);
            String indxWithoutLast = String.Join(",", indexCells);
            int cellPosition = -1;
            for (int i = 0; i < Cells.Count; i++)
            {
                int indexCount1 = Cells[i].Index.Split(',').Length;
                if (Cells[i].Index == indx)
                    cellPosition = i;


                if (indexCount1 == indexCount)
                {
                    if (Cells[i].Index.StartsWith(indxWithoutLast) || indxWithoutLast == "")
                    {
                        int last = Convert.ToInt32(theNthIndex(i, indexCount - 1));
                        if (last >= Last)
                        {

                            Cells[i].Index = AddToIndex(Cells[i].Index, indexCount - 1, -1);
                        }
                    }
                }
                else if (indexCount > indexCount1)
                {
                    if (indx.StartsWith(Cells[i].Index))
                    {
                        if (cellPosition == -1)
                            cellPosition = i;
                        Cells[i].Index = AddToIndex(Cells[i].Index, indexCount1 - 1, -1);
                    }
                }
                else if (indexCount < indexCount1)
                {
                    if (Cells[i].Index.StartsWith(indx))
                    {
                        if (cellPosition == -1)
                            cellPosition = i;
                        Cells[i].Index = AddToIndex(Cells[i].Index, indexCount - 1, -1);
                    }
                }
            }
            Cells.RemoveAt((cellPosition == -1 ? Cells.Count : cellPosition));
        }
        protected string CellWithIndex(string indx)
        {
            for (int i = 0; i < Cells.Count; i++)
            {
                if (Cells[i].Index == indx)
                {
                    return Cells[i].Text;
                }
            }
            return "";
        }

        protected int IndexWithIndex(string indx)
        {
            for (int i = 0; i < Cells.Count; i++)
            {
                if (Cells[i].Index == indx)
                {
                    return i;
                }
            }
            return -1;
        }
        protected string AddToIndex(string indx , int increament)
        {
            List<String> indexCells = new List<String>();
            indexCells.AddRange(indx.Split(','));
            int indexCount = indexCells.Count;
            int Last = Convert.ToInt32(indexCells[indexCount - 1]);
            indexCells.RemoveAt(indexCount - 1);
            String indxWithoutLast = String.Join(",", indexCells);
            
            return indxWithoutLast + (indxWithoutLast == "" ? "" : ",") + (Last + increament).ToString();
        }
        protected string AddToIndex(string indx,int id, int increament)
        {
            List<String> indexCells = new List<String>();
            indexCells.AddRange(indx.Split(','));
            int indexCount = indexCells.Count;
            int Case = Convert.ToInt32(indexCells[id]);
            String[] S = new string[indexCount];
            for(int i =0;i < indexCount; i++)
            {
                S[i] = indexCells[i];
            }
            String indxLast = "";
            String indxFirst = "";
            if ( indexCount-id-1>=0)
                indxLast = string.Join(",", S,id + 1,indexCount - id - 1);
            if(id >= 1)
                indxFirst = string.Join(",", S,0,id);

            return indxFirst + (indxFirst == "" ? "" : ",") + (Case + increament).ToString() + (indxLast == "" ? "" : ",") + indxLast;
                
            
        }
        protected string theLastIndex(int indexInArray)
        {
            string indx = Cells[indexInArray].Index;
            List<String> indexCells = new List<String>();
            indexCells.AddRange(indx.Split(','));
            if (indexCells.Count <= 0)
                return "-1";
            return indexCells[indexCells.Count - 1];
        }

        protected string theLastIndex(string indx)
        { 
            List<String> indexCells = new List<String>();
            indexCells.AddRange(indx.Split(','));
            if (indexCells.Count <= 0)
                return "-1";
            return indexCells[indexCells.Count - 1];
        }
        protected string theNthIndex(int indexInArray,int n)
        {
            string indx = Cells[indexInArray].Index;
            List<String> indexCells = new List<String>();
            indexCells.AddRange(indx.Split(','));
            if (indexCells.Count == 0 || indexCells.Count <= n)
                return "-1";
            return indexCells[n];
        }


        private Boolean isVarible(string s)
        {
            for (int i = 0; i < s.Length; i++)
            {
                if (!Char.IsLetter(s[i]))
                    return false;
            }
            return true;
        }
        private Boolean isFunction(string s)
        {
            if (s.Length > 2)
                return (s.EndsWith("()") && isVarible(s.Remove(s.Length - 2)));
            return false;
        }
    }
}
