﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MathNamespace {
    public class Math1
    {
        

        public static Double Factorial(Double num1)
        {
            num1 += 1;//to use gamma function
            double[] c = new double[6] { 76.1800917, -86.50532032941677, 24.01409824083091, -1.231739572450155, 0.1208650973866179E-2, -0.5395239384953E-5 };
            double LSTP = 0.91893853320467274178;
            double num = num1 + 1;
            double num2 = num1 + 5.5;
            double series = 1.000000000190015;
            for(int i = 0; i < 6; ++i)
            {
                series += c[i] / num;
                num += 1;
            }
            double x= (LSTP + (num1 + 0.5) * Math.Log(num2) - num2 + Math.Log(series / num1)); ;
            return Math.Exp(x);
        }

        public static Double Arcsinh(Double num1)
        {
            Double cNum;
            cNum = Math.Log(num1 + Math.Sqrt(1 + num1 * num1));
            return cNum;
        }
        public static Double Arccosh(Double num1)
        {
            Double cNum;
            cNum = Math.Log(num1 + Math.Sqrt(num1 - 1) * Math.Sqrt(num1 + 1));
            return cNum;
        }
        public static Double Arctanh(Double num1)
        {
            Double cNum;
            cNum = (0.5) * (Math.Log(1 + num1) - Math.Log(1 - num1));
            return cNum;
        }
        public static Double Arccoth(Double num1)
        {
            Double cNum;
            cNum = (0.5) * (Math.Log(1 + 1 / num1) - Math.Log(1 - 1 / num1));
            return cNum;
        }


        public static Double Arcsech(Double num1)
        {
            Double cNum;
            cNum = Math.Log(Math.Sqrt(1.0 / num1 - 1) * Math.Sqrt(1.0 / num1 + 1.0) + 1.0 / num1);
            return cNum;
        }

        public static Double Arccsch(Double num1)
        {
            Double cNum;
            cNum = Math.Log(Math.Sqrt(1 / (num1 * num1) + 1) + 1 / num1); ;
            return cNum;
        }
    }

    public class ComplexNumber
    {
        public static readonly ComplexNumber I = new ComplexNumber(0, 1);
        static int g = 7;
        static double[] p = new double[9] { 0.99999999999980993, 676.5203681218581, -1259.1392167224028, 771.32342877765313, -176.61502916214059, 12.507343278686905, -0.13857109526572012, 9.9843695780195716E-6, 1.5056327351493116E-7 };
        private Double number1;
        private Double number2;





        public ComplexNumber()
        {
        }
        public ComplexNumber(double q1, double q2)
        {
            Number1 = q1;
            Number2 = q2;
        }




        public Double Number1
        {
            get
            {
                return number1;
            }
            set
            {
                number1 = value;
            }
        }

        public Double Number2
        {
            get
            {
                return number2;
            }
            set
            {
                number2 = value;
            }
        }

        public Double Arg
        {
            get
            {
                return Math.Atan(number2 / number1);

            }
        }
        public Double Norm
        {
            get
            {
                Double Num = number1 * number1 + number2 * number2;
                return Math.Sqrt(Num);

            }
        }
        public void SetNumber(double q1, double q2)
        {
            Number1 = q1;
            Number2 = q2;
        }

        public static Double norm(ComplexNumber num)
        {
            Double Num;
            Num = num.Number1 * num.Number1 + num.Number2 * num.Number2;
            Num = Math.Sqrt(Num);
            return Num;
        }

        public static ComplexNumber Sqrt(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = Pow(num1,0.5);
            return cNum;
        }
        public static ComplexNumber Pow(ComplexNumber num1, Double num2)
        {
            Double t = Math.Atan(num1.Number2 / num1.Number1);
            Double r = num1.Norm;

            t *= num2;
            r = Math.Pow(r, num2);

            Double a = r * Math.Cos(t);
            Double b = r * Math.Sin(t);

            return new ComplexNumber(a, b);
        }
        public static ComplexNumber Pow(ComplexNumber num1, ComplexNumber num2)
        {
            Double t = Math.Atan(num1.Number2 / num1.Number1);
            Double r = num1.Norm;

            ComplexNumber cNum = new ComplexNumber(0, t);
            ComplexNumber cNum1 = new ComplexNumber();
            ComplexNumber cNum2 = new ComplexNumber();


            cNum1 = Exp(Math.Log(r) * num2);
            cNum = num2 * cNum;
            cNum2 = Exp(cNum);

            cNum = cNum1 * cNum2;

            return cNum;
        }
        public static ComplexNumber Exp(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber(1, 0);
            cNum.SetNumber(1, 0);
            cNum = num1 + 1000;
            return Exp2(cNum, num1, 1000);
        }
        public static ComplexNumber Ln(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum.Number1 = Math.Log(num1.Norm);
            cNum.Number2 = num1.Arg;
            return cNum;
        }
        public static ComplexNumber Log(ComplexNumber num1, ComplexNumber num2)
        {
            return Ln(num1) / Ln(num2);
        }
        private static ComplexNumber Exp2(ComplexNumber y, ComplexNumber x, Double n)
        {
            if (n == 0)
            {
                y = 1 / y;
                y.Number2 = y.Number2 * (-1);
                return y;
            }
            else if (n == 1)
            {
                y = 1 - x / y;
                return Exp2(y, x, n - 1);
            }
            n -= 1;
            y = (n * x) / y;
            y = x + n - y;
            return Exp2(y, x, n);
        }

        public static ComplexNumber Gamma(ComplexNumber num1)
        {
            
            if(num1.Number1 < 0.5)
            {
                return Math.PI / (ComplexNumber.Sin(Math.PI*num1)*Gamma(1-num1));
            }
            else
            {
                num1 = num1 - 1;
                ComplexNumber x = new ComplexNumber(ComplexNumber.p[0],0);
                for(int i = 1;  i < g+ 2; i++)
                {
                    x = x + p[i] / (num1 + i);
                }
                ComplexNumber t = num1 + g + 0.5;
                return ComplexNumber.Sqrt(new ComplexNumber(2 * Math.PI, 0)) * (ComplexNumber.Pow(t, num1 + 0.5)) * ComplexNumber.Exp(0 - t) * x;
            }
        }


        //trigonometric

        public static ComplexNumber Sin(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (Exp(I * num1) - Exp(I * num1 * (-1))) / (2 * I);
            return cNum;
        }

        public static ComplexNumber Cos(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (Exp(I * num1) + Exp(I * num1 * (-1))) / 2;
            return cNum;
        }
        public static ComplexNumber Tan(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = Sin(num1) / Cos(num1);
            return cNum;
        }
        public static ComplexNumber Cot(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = 1 / Tan(num1);
            return cNum;
        }


        public static ComplexNumber Sec(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = 1 / Cos(num1);
            return cNum;
        }

        public static ComplexNumber Csc(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = 1 / Sin(num1);
            return cNum;
        }

        //inverse trigonometric

        public static ComplexNumber Arcsin(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (-1) * I * Ln(I * num1 + Sqrt(1 - num1 * num1));
            return cNum;
        }
        public static ComplexNumber Arccos(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (-1) * I * Ln(num1 + Sqrt(num1 * num1 - 1));
            return cNum;
        }
        public static ComplexNumber Arctan(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (I / 2) * (Ln(1 - I * num1) - Ln(1 + I * num1));
            return cNum;
        }
        public static ComplexNumber Arccot(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (I / 2) * (Ln(1 - I / num1) - Ln(1 + I / num1));
            return cNum;
        }


        public static ComplexNumber Arcsec(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (-1) * I * Ln(Sqrt(1 - 1 / (num1 * num1)) + I / num1);
            return cNum;
        }

        public static ComplexNumber Arccsc(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (-1) * I * Ln(Sqrt(1 / (num1 * num1) - 1) + 1 / num1); ;
            return cNum;
        }
        //hyperbolic functions
        public static ComplexNumber Sinh(ComplexNumber num1)
        {
            return Sin(I * num1) / I;
        }
        public static ComplexNumber Cosh(ComplexNumber num1)
        {
            return Cos(I * num1);
        }
        public static ComplexNumber Tanh(ComplexNumber num1)
        {
            return Tan(I * num1) / I;
        }
        public static ComplexNumber Coth(ComplexNumber num1)
        {
            return (0 - Cot(I * num1) / I);
        }


        public static ComplexNumber Sech(ComplexNumber num1)
        {
            return Sec(I * num1);
        }

        public static ComplexNumber Csch(ComplexNumber num1)
        {
            return (0 - Cos(I * num1) / I);
        }
        //inverse hyperbolic functions
        public static ComplexNumber Arcsinh(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = Ln(num1 + Sqrt(1 + num1 * num1));
            return cNum;
        }
        public static ComplexNumber Arccosh(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = Ln(num1 + Sqrt(num1 - 1) * Sqrt(num1 + 1));
            return cNum;
        }
        public static ComplexNumber Arctanh(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (0.5) * (Ln(1 + num1) - Ln(1 - num1));
            return cNum;
        }
        public static ComplexNumber Arccoth(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = (0.5) * (Ln(1 + 1 / num1) - Ln(1 - 1 / num1));
            return cNum;
        }


        public static ComplexNumber Arcsech(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = Ln(Sqrt(1 / num1 - 1) * Sqrt(1 / num1 + 1) + 1 / num1);
            return cNum;
        }

        public static ComplexNumber Arccsch(ComplexNumber num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum = Ln(Sqrt(1 / (num1 * num1) + 1) + 1 / num1); ;
            return cNum;
        }
        //operators
        public static ComplexNumber operator +(ComplexNumber num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum.SetNumber(num1.Number1 + num2.Number1, num1.Number2 + num2.Number2);
            return cNum;
        }
        public static ComplexNumber operator +(Double num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum.SetNumber(num1 + num2.Number1, num2.Number2);
            return cNum;
        }
        public static ComplexNumber operator +(ComplexNumber num2, Double num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum.SetNumber(num1 + num2.Number1, num2.Number2);
            return cNum;
        }
        public static ComplexNumber operator -(ComplexNumber num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum.SetNumber(num1.Number1 - num2.Number1, num1.Number2 - num2.Number2);
            return cNum;
        }
        public static ComplexNumber operator -(Double num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum.SetNumber(num1 - num2.Number1, -num2.Number2);
            return cNum;
        }
        public static ComplexNumber operator -(ComplexNumber num2, Double num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            cNum.SetNumber(-num1 + num2.Number1, num2.Number2);
            return cNum;
        }
        public static ComplexNumber operator *(ComplexNumber num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            Double a, b, c, d;
            a = num1.Number1;
            b = num1.Number2;
            c = num2.Number1;
            d = num2.Number2;
            cNum.SetNumber(a * c - b * d, b * c + a * d);
            return cNum;
        }
        public static ComplexNumber operator *(double num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            Double a, b;

            a = num2.Number1;
            b = num2.Number2;
            cNum.SetNumber(a * num1, b * num1);
            return cNum;
        }
        public static ComplexNumber operator *(ComplexNumber num2, double num1)
        {
            ComplexNumber cNum = new ComplexNumber();
            Double a, b;

            a = num2.Number1;
            b = num2.Number2;
            cNum.SetNumber(a * num1, b * num1);
            return cNum;
        }
        public static ComplexNumber operator /(ComplexNumber num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            Double a, b, c, d, e;
            a = num1.Number1;
            b = num1.Number2;
            c = num2.Number1;
            d = num2.Number2;
            e = c * c + d * d;
            cNum.SetNumber(a * c + b * d, b * c - a * d);
            cNum.Number1 /= e;
            cNum.Number2 /= e;
            return cNum;
        }

        public static ComplexNumber operator /(ComplexNumber num1, Double num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            Double a, b;
            a = num1.Number1 / num2;
            b = num1.Number2 / num2;
            cNum.SetNumber(a, b);
            return cNum;
        }
        public static ComplexNumber operator /(Double num1, ComplexNumber num2)
        {
            ComplexNumber cNum = new ComplexNumber();
            Double a, b, c, d, e;
            a = num1;
            b = 0;
            c = num2.Number1;
            d = num2.Number2;
            e = c * c + d * d;
            cNum.SetNumber(a * c + b * d, b * c - a * d);
            cNum.Number1 /= e;
            cNum.Number2 /= e;
            return cNum;
        }
    }
    public class Number
    {
        public enum NumberType
        {
            Complex,
            Real
        };


        protected NumberType type;
        protected ComplexNumber cNum;
        protected Double rNum;

        public Number()
        {
            cNum = new ComplexNumber(0, 0);
            rNum = 0;
        }
        public Number(ComplexNumber cn)
        {
            cNum = new ComplexNumber();
            cNum.Number1 = cn.Number1;
            cNum.Number2 = cn.Number2;
            rNum = 0;
            Type = NumberType.Complex;
        }

        public Number(Double rn)
        {
            cNum = new ComplexNumber(); ;
            rNum = rn;
            Type = NumberType.Real;
        }
        public NumberType Type
        {
            get
            {
                return type;
            }
            set
            {
                type = value;
            }
        }

        public ComplexNumber ComplexNum
        {
            get
            {
                return cNum;
            }
        }
        public Double realNum
        {
            get
            {
                return rNum;
            }
        }

        public void setValue(Double number)
        {
            Type = NumberType.Real;
            rNum = number;
        }
        public void setValue(ComplexNumber number)
        {
            Type = NumberType.Complex;
            cNum.Number1 = number.Number1;
            cNum.Number2 = number.Number2;
        }
        public string ToExpressionStr()
        {
            if (Type == NumberType.Real)
                return realNum.ToString();
            else
                return ComplexNum.Number1 + "+" + ComplexNum.Number2 + "*i";
        }


        //static

        public static bool IsNaN(Number num)
        {
            if (num.Type == NumberType.Real)
            {
                return (Double.IsNaN(num.realNum));
            }
            else
            {
                return (Double.IsNaN(num.ComplexNum.Number1) || Double.IsNaN(num.ComplexNum.Number2));
            }
        }

        public static bool IsInfinity(Number num)
        {
            if (num.Type == NumberType.Real)
            {
                return (Double.IsInfinity(num.realNum) || num.realNum > Math.Pow(10, 15));
            }
            else
            {
                return (Double.IsInfinity(num.ComplexNum.Number1) || num.ComplexNum.Number1 > Math.Pow(10, 15) || Double.IsInfinity(num.ComplexNum.Number2) || num.ComplexNum.Number2 > Math.Pow(10, 15));
            }
        }


        public static Number Sqrt(Number num1)
        {
            return Number.Pow(num1, 0.5);

        }
        public static Number Pow(Number num1, Double num2)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Pow(num1.realNum, num2));
            return new Number(ComplexNumber.Pow(num1.ComplexNum, num2));
        }
        public static Number Pow(Number num1, Number num2)
        {
            if (num2.Type == NumberType.Real)
                return Number.Pow(num1, num2.realNum);
            if (num1.Type == NumberType.Real)
                return new Number(ComplexNumber.Pow(new ComplexNumber(num1.realNum, 0), num2.ComplexNum));
            return new Number(ComplexNumber.Pow(num1.ComplexNum, num2.ComplexNum));
        }
        public static Number Exp(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Exp(num1.realNum));
            return new Number(ComplexNumber.Exp(num1.ComplexNum));
        }
        public static Number Ln(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Log(num1.realNum));
            return new Number(ComplexNumber.Ln(num1.ComplexNum));
        }
        public static Number Log(Number num1, Number num2)
        {
            return Ln(num1) / Ln(num2);
        }
        public static Number Round(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Round(num1.realNum, 15));
            return new Number(new ComplexNumber(Math.Round(num1.ComplexNum.Number1, 15), Math.Round(num1.ComplexNum.Number2, 15)));
        }
        public static Number Round(Number num1,int ap)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Round(num1.realNum,ap));
            return new Number(new ComplexNumber(Math.Round(num1.ComplexNum.Number1, ap), Math.Round(num1.ComplexNum.Number2, ap)));
        }
        public static Number Factorial(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return Round(new Number(Math1.Factorial(num1.realNum)),6);
            return Round( new Number(ComplexNumber.Gamma(num1.ComplexNum + 1)),6);
        }
        //trigonometric

        public static Number Sin(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Sin(num1.realNum));
            return new Number(ComplexNumber.Sin(num1.ComplexNum));
        }
        public static Number Cos(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Cos(num1.realNum));
            return new Number(ComplexNumber.Cos(num1.ComplexNum));
        }
        public static Number Tan(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Tan(num1.realNum));
            return new Number(ComplexNumber.Tan(num1.ComplexNum));
        }
        public static Number Cot(Number num1)
        {
            return new Number(1) / Tan(num1);
        }


        public static Number Sec(Number num1)
        {
            return new Number(1) / Cos(num1);
        }

        public static Number Csc(Number num1)
        {
            return new Number(1) / Sin(num1);
        }

        //inverse trigonometric

        public static Number Arcsin(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Asin(num1.realNum));
            return new Number(ComplexNumber.Arcsin(num1.ComplexNum));
        }
        public static Number Arccos(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Acos(num1.realNum));
            return new Number(ComplexNumber.Arccos(num1.ComplexNum));
        }
        public static Number Arctan(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Atan(num1.realNum));
            return new Number(ComplexNumber.Arctan(num1.ComplexNum));
        }
        public static Number Arccot(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(1 / Math.Atan(num1.realNum));
            return new Number(1 / ComplexNumber.Arctan(num1.ComplexNum));
        }


        public static Number Arcsec(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(1 / Math.Acos(num1.realNum));
            return new Number(1 / ComplexNumber.Arccos(num1.ComplexNum));
        }

        public static Number Arccsc(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(1 / Math.Asin(num1.realNum));
            return new Number(1 / ComplexNumber.Arcsin(num1.ComplexNum));
        }
        //hyperbolic functions

        public static Number Sinh(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Sinh(num1.realNum));
            return new Number(ComplexNumber.Sinh(num1.ComplexNum));
        }
        public static Number Cosh(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Cosh(num1.realNum));
            return new Number(ComplexNumber.Cosh(num1.ComplexNum));
        }
        public static Number Tanh(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math.Tanh(num1.realNum));
            return new Number(ComplexNumber.Tanh(num1.ComplexNum));
        }
        public static Number Coth(Number num1)
        {
            return new Number(1) / Tanh(num1);
        }


        public static Number Sech(Number num1)
        {
            return new Number(1) / Cosh(num1);
        }

        public static Number Csch(Number num1)
        {
            return new Number(1) / Sinh(num1);
        }
        //inverse hperbolic

        public static Number Arcsinh(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math1.Arcsinh(num1.realNum));
            return new Number(ComplexNumber.Arcsinh(num1.ComplexNum));
        }
        public static Number Arccosh(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math1.Arccosh(num1.realNum));
            return new Number(ComplexNumber.Arccosh(num1.ComplexNum));
        }
        public static Number Arctanh(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(Math1.Arctanh(num1.realNum));
            return new Number(ComplexNumber.Arctanh(num1.ComplexNum));
        }
        public static Number Arccoth(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(1 / Math1.Arctanh(num1.realNum));
            return new Number(1 / ComplexNumber.Arctanh(num1.ComplexNum));
        }


        public static Number Arcsech(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(1 / Math1.Arccosh(num1.realNum));
            return new Number(1 / ComplexNumber.Arccosh(num1.ComplexNum));
        }

        public static Number Arccsch(Number num1)
        {
            if (num1.Type == NumberType.Real)
                return new Number(1 / Math1.Arcsinh(num1.realNum));
            return new Number(1 / ComplexNumber.Arcsinh(num1.ComplexNum));
        }

        //

        public override string ToString()
        {
            if (Type == NumberType.Real)
                return realNum.ToString();
            else
                return ComplexNum.Number1 + (ComplexNum.Number2 < 0 ? (" - " + ComplexNum.Number2 * (-1)) : (" + " + ComplexNum.Number2)) + "i";
        }

        public static Number operator +(Number num1, Number num2)
        {
            Number Num = new Number();
            if (num1.Type == NumberType.Real && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Real;
                Num.rNum = num1.rNum + num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Real && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.rNum + num2.cNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum + num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum + num2.cNum;
                return Num;
            }
            return Num;
        }
        public static Number operator -(Number num1, Number num2)
        {
            Number Num = new Number();
            if (num1.Type == NumberType.Real && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Real;
                Num.rNum = num1.rNum - num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Real && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.rNum - num2.cNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum - num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum - num2.cNum;
                return Num;
            }
            return Num;
        }

        public static Number operator *(Number num1, Number num2)
        {
            Number Num = new Number();
            if (num1.Type == NumberType.Real && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Real;
                Num.rNum = num1.rNum * num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Real && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.rNum * num2.cNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum * num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum * num2.cNum;
                return Num;
            }
            return Num;
        }

        public static Number operator /(Number num1, Number num2)
        {
            Number Num = new Number();
            if (num1.Type == NumberType.Real && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Real;
                Num.rNum = num1.rNum / num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Real && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.rNum / num2.cNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Real)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum / num2.rNum;
                return Num;
            }
            else if (num1.Type == NumberType.Complex && num2.Type == NumberType.Complex)
            {
                Num.Type = NumberType.Complex;
                Num.cNum = num1.cNum / num2.cNum;
                return Num;
            }
            return Num;
        }
    }

    public class Variable
    {

        private string vName;
        private Expression amount;


        public Variable(string name, string expr)
        {
            vName = name;
            Amount = new Expression(expr);
        }

        public Variable(string name, Expression expr)
        {
            vName = name;
            Amount = new Expression();
            Amount = expr;
        }
        public Variable(string name, Number num)
        {
            vName = name;
            Amount = new Expression();
            Amount.Type = Expression.CellType.Number;
            Amount.N = num;
        }
        public Variable()
        {
            vName = "";

        }

        public string VariableName
        {
            get
            {
                return vName;
            }
        }

        public Expression Amount
        {
            get
            {
                return amount;
            }
            set
            {
                amount = value;
            }
        }


        public void setVariable(string name, string expr)
        {
            vName = name;
            amount = new Expression(expr);
        }
        public void setVariable(string name)
        {
            vName = name;
            amount = new Expression();
        }

        public static bool IsVariable(string str, out string name)
        {
            name = "";
            if (str == "") return false;
            else if (!char.IsLetter(str[0]))
                return false;

            for (int i = 1; i < str.Length; i++)
            {
                if (!char.IsLetterOrDigit(str[i])) return false;
            }
            name = str;
            return true;
        }


    }

    public class Operator
    {
        private string name;


        public Operator(string n)
        {
            Name = n;
        }

        public Operator() { }


        public string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }


    }

    public class Function
    {
        private string name;
        private Expression criterion;
        private List<string> arcNames = new List<string>();
        public List<Expression> Arcs = new List<Expression>();



        public string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        public Expression Criterion
        {
            get
            {
                return criterion;
            }
            set
            {
                criterion = value;
            }
        }



        public List<string> ArcNames
        {
            get
            {
                return arcNames;
            }
            set
            {
                arcNames = value;
            }
        }

        public void FunctionDefinition(string name, Expression functionCritrion, params string[] variablesNmaes)
        {
            Name = name;
            Criterion = functionCritrion;
            foreach (string s in variablesNmaes)
            {
                ArcNames.Add(s);
            }

        }
        public void FunctionDefinition(string name, string functionCritrion, params string[] variablesNmaes)
        {
            Name = name;
            Criterion = new Expression(functionCritrion);
            foreach (string s in variablesNmaes)
            {
                ArcNames.Add(s);
            }

        }

        public void FunctionDefinition(string name, string functionCritrion, List<String> variablesNmaes)
        {
            Name = name;
            Criterion = new Expression(functionCritrion);
            foreach (string s in variablesNmaes)
            {
                ArcNames.Add(s);
            }

        }
        public static bool IsFunction(string str, out string name, out List<Expression> arcFuncs)
        {
            if(str.StartsWith("(") && str.EndsWith(")"))
            {
                string str1 = str.Substring(1,str.Length - 2);
                return IsFunction(str1, out name,out  arcFuncs);
            }


            name = "";
            arcFuncs = new List<Expression>();
            string arcStr = "", part = "";
            int lastIndex = -1, prnts = 0;
            int i = 1;

            if (str.Length == 0) return false;

            if (!char.IsLetter(str[0]))
                return false;

            for (i = 1; i < str.Length; i++)
            {
                if (str[i] == '(')
                    break;
                if (!char.IsLetterOrDigit(str[i])) return false;
            }
            if (!str.EndsWith(")"))
                return false;


            if (arePairPrnts(str, str.IndexOf('('), str.Length - 1))
            {
                name = str.Remove(str.IndexOf("("));
                arcStr = str.Substring(str.IndexOf("(") + 1, str.LastIndexOf(")") - str.IndexOf("(") - 1);

                //copy
                i = 0;
                for (i = 0; i < arcStr.Length; i++)
                {
                    if (arcStr[i] == '(')
                        prnts++;
                    else if (arcStr[i] == ')')
                        prnts--;
                    if (arcStr[i] == ',' && prnts == 0)
                    {
                        part = arcStr.Substring(lastIndex + 1, i - lastIndex - 1);


                        Expression ex = new Expression(part);
                        arcFuncs.Add(ex);

                        lastIndex = i;
                    }
                }
                part = arcStr.Substring(lastIndex + 1, arcStr.Length - lastIndex - 1);


                Expression ex1 = new Expression(part);
                arcFuncs.Add(ex1);
                //copy
                return true;
            }
            else
                return false;
        }

        public static bool arePairPrnts(string str, int a, int b)
        {
            int? c = null, prnts = 0;
            bool pAppear = false;
            if (!(a >= 0 && a < str.Length && b > 0 && b < str.Length)) return false;
            for (int i = 0; i < str.Length; i++)
            {
                if (str[i] == '(')
                {

                    if (i == a)
                    {
                        c = prnts;
                        pAppear = true;
                    }
                    prnts++;

                }
                if (str[i] == ')')
                {
                    prnts--;
                    if (pAppear)
                    {

                        if (c == prnts)
                            if (i == b)
                                return true;
                            else
                                return false;

                    }
                    else
                        return false;
                }

            }
            return false;
        }
    }


    public class Cells
    {
        public List<Expression> cells = new List<Expression>();
    }
    public class Expression
    {
        public enum CellType
        {
            Number,
            Variable,
            Operator,
            Formula,
            Function,
            Other // non Completed Cells
        };


        private static class Data
        {
            public static List<Function> Functions = new List<Function>();
            public static List<Variable> Variables = new List<Variable>();
        }


        private string expressionStr;
        private static bool isComputable = false;
        private static bool isMainExpression = true;

        public CellType Type = CellType.Other;
        public Variable V = new Variable();
        public Number N = new Number();
        public Operator O = new Operator();
        public Cells C = new Cells();
        public String S;
        public Function F = new Function();


        public List<Variable> Variables = new List<Variable>();
        public Number value = new Number();

        public Expression()
        {

        }
        public Expression(string exStr)
        {
            setExpression(exStr);
        }



        public Number Value
        {
            set
            {
                this.value = value;
                Type = CellType.Number;
                N = value;
            }
            get
            {
                switch (Type)
                {
                    case CellType.Number:
                        Type = CellType.Number;
                        return N;

                    case CellType.Variable:

                        //Type = CellType.Number;

                        return searchVariable(V.VariableName, Variables);

                    case CellType.Formula:
                        setVariables(ref C.cells, Variables);
                        return calculateFormula(C);
                    case CellType.Function:
                        setVariables(ref F.Arcs, Variables);
                        return answerFunction(F.Name, F.Arcs);

                }
                isComputable = false;
                return new Number();
            }
        }

        public static bool IsComputable
        {

            get
            {
                return isComputable;
            }
        }

        private static string toMathExpression(string designExpression)
        {
            designExpression = designExpression.Replace('[', '(');
            designExpression = designExpression.Replace(']', ')');
            designExpression = designExpression.Replace(" ", "");
            return designExpression;
        }
        private static Number searchVariable(string vName, List<Variable> vs)
        {

            Number n = new Number();
            switch (vName)
            {
                case "i":
                    n = new Number();
                    n.setValue(ComplexNumber.I);
                    return n;
                case "π":
                case "pi":
                    n = new Number();
                    n.setValue(Math.PI);
                    return n;
                case "e":
                    n = new Number();
                    n.setValue(Math.E);
                    return n;
            }
            foreach (Variable I in vs)
            {
                if (I.VariableName == vName)
                {
                    I.Amount.Variables.Clear();
                    for (int j = 0; j < vs.Count; j++)
                    {
                        Variable v = new Variable(vs[j].VariableName, vs[j].Amount);
                        I.Amount.Variables.Add(v);
                    }
                    return I.Amount.Value;
                }
            }
            isComputable = false;
            return new Number();
        }
        private static Number answerFunction(string name, List<Expression> arcs)
        {
            if (name == "Sqrt" && arcs.Count == 1)
                return Number.Sqrt(arcs[0].Value);
            else if (name == "Exp" && arcs.Count == 1)
                return Number.Exp(arcs[0].Value);
            else if (name == "Factorial" && arcs.Count == 1)
                return Number.Factorial(arcs[0].Value);
            else if (name == "Ln" && arcs.Count == 1)
                return Number.Ln(arcs[0].Value);
            else if (name == "Pow" && arcs.Count == 2)
                return Number.Pow(arcs[0].Value, arcs[1].Value);
            else if (name == "Log" && arcs.Count == 2)
                return Number.Log(arcs[0].Value, arcs[1].Value);
            else if (name == "Sin" && arcs.Count == 1)
                return Number.Sin(arcs[0].Value);
            else if (name == "Cos" && arcs.Count == 1)
                return Number.Cos(arcs[0].Value);
            else if (name == "Tan" && arcs.Count == 1)
                return Number.Tan(arcs[0].Value);
            else if (name == "Cot" && arcs.Count == 1)
                return Number.Cot(arcs[0].Value);
            else if (name == "Sec" && arcs.Count == 1)
                return Number.Sec(arcs[0].Value);
            else if (name == "Csc" && arcs.Count == 1)
                return Number.Csc(arcs[0].Value);
            else if (name == "ASin" && arcs.Count == 1)
                return Number.Arcsin(arcs[0].Value);
            else if (name == "ACos" && arcs.Count == 1)
                return Number.Arccos(arcs[0].Value);
            else if (name == "ATan" && arcs.Count == 1)
                return Number.Arctan(arcs[0].Value);
            else if (name == "ACot" && arcs.Count == 1)
                return Number.Arccot(arcs[0].Value);
            else if (name == "ASec" && arcs.Count == 1)
                return Number.Arcsec(arcs[0].Value);
            else if (name == "ACsc" && arcs.Count == 1)
                return Number.Arccsc(arcs[0].Value);
            else if (name == "Sinh" && arcs.Count == 1)
                return Number.Sinh(arcs[0].Value);
            else if (name == "Cosh" && arcs.Count == 1)
                return Number.Cosh(arcs[0].Value);
            else if (name == "Tanh" && arcs.Count == 1)
                return Number.Tanh(arcs[0].Value);
            else if (name == "Coth" && arcs.Count == 1)
                return Number.Coth(arcs[0].Value);
            else if (name == "Sech" && arcs.Count == 1)
                return Number.Sech(arcs[0].Value);
            else if (name == "Csch" && arcs.Count == 1)
                return Number.Csch(arcs[0].Value);
            else if (name == "ASinh" && arcs.Count == 1)
                return Number.Arcsinh(arcs[0].Value);
            else if (name == "ACosh" && arcs.Count == 1)
                return Number.Arccosh(arcs[0].Value);
            else if (name == "ATanh" && arcs.Count == 1)
                return Number.Arctanh(arcs[0].Value);
            else if (name == "ACoth" && arcs.Count == 1)
                return Number.Arccoth(arcs[0].Value);
            else if (name == "ASech" && arcs.Count == 1)
                return Number.Arcsech(arcs[0].Value);
            else if (name == "ACsch" && arcs.Count == 1)
                return Number.Arccsch(arcs[0].Value);
            



            foreach (Function I in Data.Functions)
            {
                if (I.Name == name && arcs.Count == I.ArcNames.Count)
                {
                    Function f = new Function();


                    f.Criterion = new Expression(I.Criterion.getExpression());

                    f.Criterion.Variables.Clear();

                    for (int i = 0; i < I.ArcNames.Count; i++)
                        f.Criterion.Variables.Add(new Variable(I.ArcNames[i], arcs[i].Value));


                    return f.Criterion.Value;
                }
            }

            isComputable = false;
            return new Number();
        }
        private static void setVariables(ref List<Expression> cs, List<Variable> vs)
        {
            for (int i = 0; i < cs.Count; i++)
            {
                cs[i].Variables.Clear();
                cs[i].Variables.AddRange(vs);
            }

        }
        private static Number calculateFormula(Cells cs)
        {

            int d = 0;
            bool find = true;

            while (find)
            {
                find = false;
                d = -1;

                d = cs.cells.FindIndex(c => (c.O.Name == "/" || c.O.Name == "*") && c.Type == CellType.Operator);
                find = (d == -1) ? false : true;
                if (find)
                {
                    switch (cs.cells[d].O.Name)
                    {
                        case "*":
                            cs.cells[d - 1].Value = cs.cells[d - 1].Value * cs.cells[d + 1].Value;
                            cs.cells.RemoveAt(d + 1);
                            cs.cells.RemoveAt(d);

                            break;
                        case "/":
                            cs.cells[d - 1].Value = cs.cells[d - 1].Value / cs.cells[d + 1].Value;
                            cs.cells.RemoveAt(d + 1);
                            cs.cells.RemoveAt(d);
                            break;
                    }
                }
            }


            find = true;

            while (find)
            {
                find = false;
                d = -1;

                d = cs.cells.FindIndex(c => (c.O.Name == "+" || c.O.Name == "-") && c.Type == CellType.Operator);
                find = (d == -1) ? false : true;
                if (find)
                {
                    switch (cs.cells[d].O.Name)
                    {
                        case "+":
                            if (d == 0)
                            {
                                cs.cells.RemoveAt(d);
                            }
                            else
                            {
                                cs.cells[d - 1].Value = cs.cells[d - 1].Value + cs.cells[d + 1].Value;
                                cs.cells.RemoveAt(d + 1);
                                cs.cells.RemoveAt(d);
                            }


                            break;
                        case "-":
                            if (d == 0)
                            {
                                cs.cells.RemoveAt(d);
                                cs.cells[0].Value = new Number(0) - cs.cells[0].Value;
                            }
                            else
                            {
                                cs.cells[d - 1].Value = cs.cells[d - 1].Value - cs.cells[d + 1].Value;
                                cs.cells.RemoveAt(d + 1);
                                cs.cells.RemoveAt(d);
                            }

                            break;
                    }
                }
            }

            return cs.cells[0].Value;
        }

        private void LoadData()
        {
            Variables.Clear();
            Variables.AddRange(Data.Variables);
        }



        public void setExpression(string exStr)
        {
            exStr = toMathExpression(exStr);
            expressionStr = exStr;


            string part = exStr;
            int lastIndex = -1;
            Double result;
            string name;
            List<Expression> funcArcs;
            int prnts = 0;
            bool PosNeg = false;



            if (isMainExpression)
            {
                LoadData();
                isComputable = true;
                isMainExpression = false;
            }



            if (part == "")
            {
                Type = CellType.Other;
                S = part;
                isComputable = false;
            }
            if (Double.TryParse(part, out result))
            {
                Type = CellType.Number;
                Number value = new Number();
                //v.Type = Number.ValueType.Real;  this code is in setValue function
                value.setValue(result);
                N = value;
            }
            else if (Variable.IsVariable(part, out name))
            {

                Type = CellType.Variable;
                Variable value = new Variable();
                value.setVariable(name);



                V = value;

            }
            else if (Function.IsFunction(part, out name, out funcArcs))
            {

                Type = CellType.Function;
                Function func = new Function();
                func.Name = name;
                func.Arcs = funcArcs;
                F = func;

            }
            else if (arePairPrnts(part, 0, part.Length - 1))
            {

                Type = CellType.Formula;
                part = part.Remove(0, 1);
                part = part.Remove(part.Length - 1, 1);
                setExpression(part);

            }
            else if (part.IndexOf('+') == -1 && part.IndexOf('-') == -1 && part.IndexOf('*') == -1 && part.IndexOf('/') == -1)
            {
                Type = CellType.Other;
                S = part;
                isComputable = false;
            }
            else
            {
                Type = CellType.Formula;
                for (int i = 0; i < exStr.Length; i++)
                {
                    if (exStr[i] == '(')
                        prnts++;
                    else if (exStr[i] == ')')
                        prnts--;
                    if ("+-*/".IndexOf(exStr[i]) != -1 && prnts == 0)
                    {

                        part = exStr.Substring(lastIndex + 1, i - lastIndex - 1);

                        if (part == "")
                        {
                            if (i == 0 && (exStr[i] == '+' || exStr[i] == '-')) ;//do nothing
                            else if ((exStr[i - 1] == '+' || exStr[i - 1] == '-') && (exStr[i] == '+' || exStr[i] == '-'))
                            {
                                if (C.cells[C.cells.Count - 1].O.Name == "+" && exStr[i] == '+')
                                {
                                    //C.cells[C.cells.Count - 1].O.Name = "+";

                                    PosNeg = true;
                                }
                                else if (C.cells[C.cells.Count - 1].O.Name == "-" && exStr[i] == '+')
                                {
                                    //C.cells[C.cells.Count - 1].O.Name = "-";
                                    PosNeg = true;
                                }
                                if (C.cells[C.cells.Count - 1].O.Name == "+" && exStr[i] == '-')
                                {
                                    C.cells[C.cells.Count - 1].O.Name = "-";
                                    PosNeg = true;
                                }
                                else if (C.cells[C.cells.Count - 1].O.Name == "-" && exStr[i] == '-')
                                {
                                    C.cells[C.cells.Count - 1].O.Name = "+";
                                    PosNeg = true;
                                }
                            }
                            else
                            {
                                Expression ex = new Expression();
                                ex.Type = CellType.Other;
                                ex.S = part;
                                C.cells.Add(ex);
                                isComputable = false;
                            }
                        }
                        else if (Double.TryParse(part, out result))
                        {
                            Expression ex = new Expression();
                            ex.Type = CellType.Number;
                            Number value = new Number();
                            //v.Type = Number.ValueType.Real;  this code is in setValue function
                            value.setValue(result);
                            ex.N = value;
                            C.cells.Add(ex);
                        }
                        else if (Variable.IsVariable(part, out name))
                        {
                            Expression ex = new Expression();
                            ex.Type = CellType.Variable;
                            Variable value = new Variable();
                            value.setVariable(name);






                            ex.V = value;
                            C.cells.Add(ex);
                        }
                        else if (Function.IsFunction(part, out name, out funcArcs))
                        {
                            Expression ex = new Expression();
                            ex.Type = CellType.Function;
                            Function func = new Function();
                            func.Name = name;
                            func.Arcs = funcArcs;
                            ex.F = func;
                            C.cells.Add(ex);
                        }
                        else if (arePairPrnts(part, 0, part.Length - 1))
                        {
                            Expression ex = new Expression();
                            ex.Type = CellType.Formula;
                            part = part.Remove(0, 1);
                            part = part.Remove(part.Length - 1, 1);
                            ex.setExpression(part);
                            C.cells.Add(ex);
                        }
                        else
                        {
                            Expression ex = new Expression();
                            ex.Type = CellType.Other;
                            ex.S = part;
                            C.cells.Add(ex);
                            isComputable = false;
                        }
                        if (!PosNeg)
                        {
                            Expression ex1 = new Expression();
                            ex1.Type = CellType.Operator;
                            Operator opt = new Operator(exStr[i].ToString());
                            ex1.O = opt;
                            C.cells.Add(ex1);
                            PosNeg = false;
                        }


                        //setVariables(C.cells, Variables);

                        lastIndex = i;
                    }

                }

                if (prnts == 0)
                {

                    part = exStr.Substring(lastIndex + 1, exStr.Length - lastIndex - 1);

                    Expression ex2 = new Expression();
                    if (part == "")
                    {

                        ex2.Type = CellType.Other;
                        ex2.S = part;
                        C.cells.Add(ex2);
                        isComputable = false;
                    }
                    else if (Double.TryParse(part, out result))
                    {

                        ex2.Type = CellType.Number;
                        Number value = new Number();
                        //v.Type = Number.ValueType.Real;  this code is in setValue function
                        value.setValue(result);
                        ex2.N = value;
                        C.cells.Add(ex2);
                    }
                    else if (Variable.IsVariable(part, out name))
                    {

                        ex2.Type = CellType.Variable;
                        Variable value = new Variable();
                        value.setVariable(name);



                        ex2.V = value;
                        C.cells.Add(ex2);
                    }
                    else if (Function.IsFunction(part, out name, out funcArcs))
                    {

                        ex2.Type = CellType.Function;
                        Function func = new Function();
                        func.Name = name;
                        func.Arcs = funcArcs;
                        ex2.F = func;
                        C.cells.Add(ex2);
                    }
                    else if (arePairPrnts(part, 0, part.Length - 1))
                    {

                        ex2.Type = CellType.Formula;
                        part = part.Remove(0, 1);
                        part = part.Remove(part.Length - 1, 1);
                        ex2.setExpression(part);
                        C.cells.Add(ex2);
                    }
                    else
                    {

                        ex2.Type = CellType.Other;
                        ex2.S = part;
                        C.cells.Add(ex2);
                        isComputable = false;
                    }
                    //ex2.Variables = Variables;//like the following code . but just for one element : setVariables(C, Variables);
                }
                else
                    isComputable = false;
            }


        }

        public void IsMainExpression()
        {
            isMainExpression = true;
        }

        public static bool arePairPrnts(string str, int a, int b)
        {
            int? c = null, prnts = 0;
            bool pAppear = false;
            if (!(a >= 0 && a < str.Length && b > 0 && b < str.Length)) return false;
            for (int i = 0; i < str.Length; i++)
            {
                if (str[i] == '(')
                {

                    if (i == a)
                    {
                        c = prnts;
                        pAppear = true;
                    }
                    prnts++;

                }
                if (str[i] == ')')
                {
                    prnts--;
                    if (pAppear)
                    {

                        if (c == prnts)
                            if (i == b)
                                return true;
                            else
                                return false;

                    }
                    else
                        return false;
                }

            }
            return false;
        }
        public string getExpression()
        {
            return expressionStr;
        }

        public static void AddData(Variable v)
        {
            Data.Variables.Add(v);
            isMainExpression = true;
        }
        public static void AddData(Function v)
        {
            Data.Functions.Add(v);
            isMainExpression = true;
        }
        public static void ClearData()
        {
            Data.Functions.Clear();
            Data.Variables.Clear();
        }

        public static bool IsThereVariable(string name)
        {
            foreach (Variable V in Data.Variables)
            {
                if (V.VariableName == name) return true;
            }
            return false;
        }

        public static bool IsThereFunction(string name, int arcsCount)
        {
            foreach (Function F in Data.Functions)
            {
                if (F.Name == name && F.Arcs.Count == arcsCount) return true;
            }
            return false;
        }

        public static void SetVariable(string name, Number num)
        {

            for (int i = 0; i < Data.Variables.Count; i++)
            {
                if (Data.Variables[i].VariableName == name)
                {
                    Data.Variables.RemoveAt(i);
                    break;
                }
            }

            AddData(new Variable(name, num));
        }
    }

    public static class Calculate
    {
        private class Loop
        {
            public int LineNumber;
            public int RepeatCount;
        }
        public static void reset()
        {
            Expression.ClearData();
            Variable ansVar = new Variable("Ans", "");
            Expression.AddData(ansVar);
        }
        public static void RecognizeAndCalculate(ref List<string> Expressions)
        {
            Expression.ClearData();
            Variable ansVar = new Variable("Ans", "");
            Expression.AddData(ansVar);

            


            String[] ExpressionAns = new String[Expressions.Count];
            for(int i = 0;i < ExpressionAns.Length; i++)
            {
                ExpressionAns[i] = "";
            }
            List<Loop> loop = new List<Loop>();

            int j = 0;
            Loop l1 = new Loop();
            l1.LineNumber = -1;
            l1.RepeatCount = 1;
            loop.Add(l1);

        UserLoop:

            for (; j < Expressions.Count; j++)
            {
                
                if (Expressions[j].StartsWith("{") && Expressions[j].EndsWith("}"))
                {
                    string part = Expressions[j];
                    part = part.Remove(0, 1);
                    part = part.Remove(part.Length - 1);

                    Expression ex = new Expression(part);
                    ex.IsMainExpression();
                    Number N = new Number();
                    N = Number.Round(ex.Value);
                    if (!Expression.IsComputable || N.Type == Number.NumberType.Complex)
                        ExpressionAns[j] += "Incorract expression in loop\n";
                    else
                    {
                        if (Number.IsNaN(N))
                            ExpressionAns[j] += "Out of range error in loop expression\n";
                        else if (Number.IsInfinity(N) || N.realNum > 1000)
                            ExpressionAns[j] += "Very big number in loop expression\n";
                        else
                        {
                            Loop l = new Loop();
                            l.LineNumber = j;
                            l.RepeatCount = (int)(N.realNum);
                            loop.Add(l);
                        }
                    }
                }
                else if (Expressions[j] == "")
                {

                    if (loop.Count == 0) { }
                    else
                    {
                        if (loop[loop.Count - 1].RepeatCount <= 1)
                            loop.RemoveAt(loop.Count - 1);
                        else
                        {
                            j = loop[loop.Count - 1].LineNumber + 1;
                            loop[loop.Count - 1].RepeatCount -= 1;
                            goto UserLoop;
                        }
                    }
                }
                else
                {
                    if (loop.Count > 0)
                        if (loop[loop.Count - 1].RepeatCount >= 0)
                            ExpressionAns[j] += RecognizeAndCalculate(Expressions[j]) + "\n";
                }

            }
            while (loop.Count > 0 && loop[loop.Count - 1].RepeatCount <= 1)
                loop.RemoveAt(loop.Count - 1);

            if (loop.Count == 0) ;
            else
            {
                j = loop[loop.Count - 1].LineNumber + 1;
                loop[loop.Count - 1].RepeatCount--;
                goto UserLoop;
            }

            for (int i = 0; i < Expressions.Count; i++)
            {
                Expressions[i] = ExpressionAns[i];
            }


        }
        public static string RecognizeAndCalculate(string Expressions)
        {



            string[] signs = new string[] { ":=", "==", "!=", ">=", "<=", ">", "<", "=", ":" };
            int? solves;


            Expressions = Expressions.Replace(" ", "");
            int? n;
            n = 0;
            solves = n;
            string s = Expressions;
            for (int j = 0; j < signs.Length; j++)
            {
                if (s.IndexOf(signs[j]) != -1)
                {
                    if (s.IndexOf(signs[j]) == s.LastIndexOf(signs[j]))
                        if (n == 0)
                        {
                            n = j + 1;
                            s = s.Remove(s.IndexOf(signs[j]), signs[j].Length);
                        }
                        else
                        {
                            n = null;
                            break;
                        }
                    else
                    {
                        n = null;
                        break;//the sign repeats
                    }
                }
            }

            switch (n)
            {
                case null:
                    Expressions = "Syntax error";
                    solves = n;
                    break;
                case 0:
                    break;//do nothing
                case 1:
                    string exp1 = Expressions.Substring(0, Expressions.IndexOf(":="));
                    string exp2 = Expressions.Substring(Expressions.IndexOf(":=") + 2);
                    string name;
                    string funcName;
                    List<Expression> funcArcs = new List<Expression>();

                    solves = n;


                    if (Variable.IsVariable(exp1, out name))
                    {
                        if (Expression.IsThereVariable(name))
                            Expressions = "There is a Variable with this name.";
                        else
                        {
                            Variable V = new Variable(name, exp2);
                            Expression.AddData(V);
                            Expressions = "Variable '" + name + "' defined";
                        }
                    }
                    else if (Function.IsFunction(exp1, out funcName, out funcArcs))
                    {
                        bool isFuncDef = true;
                        List<string> arcNames = new List<string>();
                        for (int j = 0; j < funcArcs.Count; j++)
                        {
                            if (Variable.IsVariable(funcArcs[j].getExpression(), out name))
                                arcNames.Add(name);
                            else
                            {
                                isFuncDef = false;
                                break;
                            }

                        }
                        if (isFuncDef)
                        {
                            if (Expression.IsThereFunction(name, funcArcs.Count))
                                Expressions = "There is a Function with this name and this count of arc variables.";
                            else
                            {
                                Function F = new Function();
                                F.FunctionDefinition(funcName, exp2, arcNames);
                                Expression.AddData(F);
                                solves = null;
                                Expressions = "Function '" + funcName + "' defined.";
                            }

                        }
                        else
                        {
                            solves = null;
                            Expressions = "Function definition is invalid.";
                        }

                    }
                    else
                    {
                        solves = null;
                        Expressions = "invalid function or variable";
                    }
                    break;
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:

                    solves = n;
                    break;
                case 8:
                    solves = null;
                    Expressions = "Can't solve equations yet.";
                    break;
                case 9:
                    solves = 9;
                    break;

            }


            switch (solves)
            {
                case null:
                    break;//do nothing
                case 0:
                    Expression ex = new Expression(Expressions);
                    ex.IsMainExpression();
                    Number N = new Number();
                    N = Number.Round(ex.Value);
                    Expression.SetVariable("Ans", N);
                    if (!Expression.IsComputable)
                        Expressions = "Incorract expression";
                    else
                    {
                        if (Number.IsNaN(N))
                            Expressions = "Out of range error";
                        else if (Number.IsInfinity(N))
                            Expressions = "Infinity or very big";
                        else
                            Expressions =N.ToString();
                    }

                    break;
                case 1:
                    break;//do nothing
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                    string s1 = Expressions.Substring(0, Expressions.IndexOf(signs[(int)solves - 1]));
                    string s2 = Expressions.Substring(Expressions.IndexOf(signs[(int)solves - 1]) + signs[(int)solves - 1].Length);
                    bool b1, b2;
                    Expression ex1 = new Expression(s1);
                    ex1.IsMainExpression();
                    Number N1 = new Number();
                    N1 = Number.Round(ex1.Value);
                    b1 = Expression.IsComputable;

                    Expression ex2 = new Expression(s2);
                    ex2.IsMainExpression();
                    Number N2 = new Number();
                    N2 = Number.Round(ex2.Value);
                    b2 = Expression.IsComputable;
                    if (!b1 || !b2)
                        Expressions = "Incorract expression";
                    else
                    {
                        if (Number.IsNaN(N1) || Number.IsNaN(N2))
                            Expressions = "Out of range error";
                        else if (Number.IsInfinity(N1) || Number.IsInfinity(N2))
                            Expressions = "Infinity or very big";
                        else
                            Expressions = compare(N1, N2, signs[(int)solves - 1]);
                    }

                    break;
                case 8:
                    Expressions = "Can't solve equations yet";
                    break;
                case 9:
                    string exp3 = Expressions.Substring(0, Expressions.IndexOf(":"));
                    string exp4 = Expressions.Substring(Expressions.IndexOf(":") + 1);
                    string name1;
                    if (Variable.IsVariable(exp3, out name1))
                    {
                        if (!Expression.IsThereVariable(name1))
                            Expressions = "Firstly declare variable '" + name1 + "'";
                        else
                        {
                            Number n1 = new Number();
                            Expression e = new Expression(exp4);
                            n1 = e.Value;
                            n1 = Number.Round(n1);
                            if (!Expression.IsComputable)
                                Expressions = "Incorract expression";
                            else
                            {
                                if (Number.IsNaN(n1))
                                    Expressions = "Out of range error";
                                else if (Number.IsInfinity(n1))
                                {
                                    Expressions = "Answer is infinity or very big";
                                    Expression.SetVariable(name1, n1);
                                }
                                else
                                {
                                    Expression.SetVariable(name1, n1);
                                    Expressions = name1 + " = " + n1.ToString();
                                }
                            }

                        }
                    }
                    else
                        Expressions = "Just variables can be assigned";
                    break;

            }
            return Expressions;
        }

        private static string compare(Number num1, Number num2, string c)
        {
            if (c == "==")
            {
                if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Real)
                {
                    if (num1.realNum == num2.realNum)
                        return "True";
                    else
                        return "False";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.ComplexNum.Number1 == num2.ComplexNum.Number1 && num1.ComplexNum.Number2 == num2.ComplexNum.Number2)
                        return "True";
                    else
                        return "False";
                }
                else if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.realNum == num2.ComplexNum.Number1 && num2.ComplexNum.Number2 == 0)
                        return "True";
                    else
                        return "False";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Real)
                {
                    if (num1.ComplexNum.Number1 == num2.realNum && num1.ComplexNum.Number2 == 0)
                        return "True";
                    else
                        return "False";
                }
            }
            else if (c == "!=")
            {
                if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Real)
                {
                    if (num1.realNum == num2.realNum)
                        return "False";
                    else
                        return "True";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.ComplexNum.Number1 == num2.ComplexNum.Number1 && num1.ComplexNum.Number2 == num2.ComplexNum.Number2)
                        return "False";
                    else
                        return "True";
                }
                else if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.realNum == num2.ComplexNum.Number1 && num2.ComplexNum.Number2 == 0)
                        return "False";
                    else
                        return "True";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Real)
                {
                    if (num1.ComplexNum.Number1 == num2.realNum && num1.ComplexNum.Number2 == 0)
                        return "False";
                    else
                        return "True";
                }
            }
            else if (c == ">=")
            {
                if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Real)
                {
                    if (num1.realNum >= num2.realNum)
                        return "True";
                    else
                        return "False";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.ComplexNum.Number2 == 0 && num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 >= num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";

                }
                else if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Complex)
                {
                    if (num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.realNum >= num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";


                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Real)
                {
                    if (num1.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 >= num2.realNum)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";


                }
            }
            else if (c == "<=")
            {
                if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Real)
                {
                    if (num1.realNum <= num2.realNum)
                        return "True";
                    else
                        return "False";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.ComplexNum.Number2 == 0 && num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 <= num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";

                }
                else if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Complex)
                {
                    if (num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.realNum <= num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";


                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Real)
                {
                    if (num1.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 <= num2.realNum)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";


                }
            }
            else if (c == "<")
            {
                if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Real)
                {
                    if (num1.realNum < num2.realNum)
                        return "True";
                    else
                        return "False";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.ComplexNum.Number2 == 0 && num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 < num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";

                }
                else if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Complex)
                {
                    if (num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.realNum < num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";


                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Real)
                {
                    if (num1.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 < num2.realNum)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";
                }
            }
            else if (c == ">")
            {
                if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Real)
                {
                    if (num1.realNum > num2.realNum)
                        return "True";
                    else
                        return "False";
                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Complex)
                {
                    if (num1.ComplexNum.Number2 == 0 && num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 > num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";

                }
                else if (num1.Type == Number.NumberType.Real && num2.Type == Number.NumberType.Complex)
                {
                    if (num2.ComplexNum.Number2 == 0)
                    {
                        if (num1.realNum > num2.ComplexNum.Number1)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";


                }
                else if (num1.Type == Number.NumberType.Complex && num2.Type == Number.NumberType.Real)
                {
                    if (num1.ComplexNum.Number2 == 0)
                    {
                        if (num1.ComplexNum.Number1 > num2.realNum)
                            return "True";
                        else
                            return "False";
                    }
                    else
                        return "Can't compare two complex numbers";
                }
            }
            return "Something wrong happened.";
        }
    }
}