﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using MathNamespace;

namespace Calculator
{
    public partial class Form1 : Form
    {
        private List<string> expressins;
        private int selectedExpression=0;
        public Form1()
        {
            expressins = new List<string>();
            InitializeComponent();
        }


        private void ClearBtn_Click(object sender, EventArgs e)
        {
            Calculate.reset();
            InputTextBox.Clear();
        }

        private void txtInput(object sender, KeyEventArgs e)
        {
            if (e.KeyValue == (int)Keys.Enter && InputTextBox.Lines.Length > 0)
            {
                string result,expressin;
                expressin = InputTextBox.Lines[InputTextBox.Lines.Length - 1];
                result = Calculate.RecognizeAndCalculate(expressin);
                
                expressins.Add(expressin);
                InputTextBox.AppendText("\n-->" + result);
                selectedExpression++;
            }
            
        }

        private void txtInput(object sender, MouseEventArgs e)
        {
            string result, expressin;
            expressin = InputTextBox.Lines[InputTextBox.Lines.Length - 1];
            result = Calculate.RecognizeAndCalculate(expressin);
            
            expressins.Add(expressin);
            InputTextBox.AppendText("\n-->" + result + '\n');
            selectedExpression++;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ClearBtn.Left = this.Width - 140;
            button1.Left = this.Width - 140;
            InputTextBox.Width = this.Width - 145 - 10;
            InputTextBox.Height = this.Height;
        }
    }
}
