﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MathTextBox
{
    public static class Translator
    {

        public static string Translate(List<SubordinateCell> cells, int level)
        {
            string Result = "";

            int MaxIndex = int.MinValue;
            for (int i = 0; i < cells.Count; i++)
            {
                int d = Convert.ToInt32(cells[i].Index.Split(',')[level]);
                if (d > MaxIndex)
                    MaxIndex = d;
            }


            List<List<SubordinateCell>> cellsParts = new List<List<SubordinateCell>>();
            for (int i = 0; i <= MaxIndex; i++)
            {
                List<SubordinateCell> cellsPart = new List<SubordinateCell>();
                for (int j = 0; j < cells.Count; j++)
                {
                    int d = Convert.ToInt32(cells[j].Index.Split(',')[level]);
                    if (d == i)
                    {
                        SubordinateCell cell = new SubordinateCell();
                        cell.Index = cells[j].Index;
                        cell.Text = cells[j].Text;
                        cellsPart.Add(cell);
                    }
                }
                cellsParts.Add(cellsPart);
            }

            if (cellsParts.Count == 0)
                return "";






            if (cellsParts.Count == 3 && cellsParts[1].Count == 1 && cellsParts[1][0].Text == "/")
            {


                Result += "(";

                if (cellsParts[0].Count == 1)
                {
                    if (isNumber(cellsParts[0][0].Text))//number
                    {
                        Result += cellsParts[0][0].Text;
                    }
                    else if (cellsParts[0][0].Text == "*" || cellsParts[0][0].Text == "/" || cellsParts[0][0].Text == "+" || cellsParts[0][0].Text == "-")//operator
                    {
                        Result += cellsParts[0][0].Text;
                    }
                    else if (isVarible(cellsParts[0][0].Text))//Variable
                    {
                        Result += cellsParts[0][0].Text;
                    }
                    else if (cellsParts[0][0].Text == " ")
                    {
                        Result += cellsParts[0][0].Text;
                    }
                    else
                    {
                        Result += cellsParts[0][0].Text;
                    }
                }
                else
                {
                    Result += "(";
                    Result += Translate(cellsParts[0], level + 1);
                    Result += ")";
                }


                Result += ")/(";



                if (cellsParts[2].Count == 1)
                {
                    if (isNumber(cellsParts[2][0].Text))//number
                    {
                        Result += cellsParts[2][0].Text;
                    }
                    else if (cellsParts[2][0].Text == "*" || cellsParts[2][0].Text == "/" || cellsParts[2][0].Text == "+" || cellsParts[2][0].Text == "-")//operator
                    {
                        Result += cellsParts[2][0].Text;
                    }
                    else if (isVarible(cellsParts[2][0].Text))//Variable
                    {
                        Result += cellsParts[2][0].Text;
                    }
                    else if (cellsParts[2][0].Text == " ")
                    {
                        Result += cellsParts[2][0].Text;
                    }
                    else
                    {
                        Result += cellsParts[2][0].Text;
                    }
                }
                else
                {
                    Result += "(";
                    Result += Translate(cellsParts[2], level + 1);
                    Result += ")";
                }

                Result += ")";
            }
            else if (cellsParts[0].Count == 1)
            {
                if (cellsParts[0][0].Text == "()")
                {
                    if (cellsParts.Count == 1)
                    {
                        return "";
                    }
                    Result += "(";

                    for (int i = 1; i < cellsParts.Count; i++)
                    {
                        if (cellsParts[i].Count == 1)
                        {
                            if (isNumber(cellsParts[i][0].Text))//number
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (isVarible(cellsParts[i][0].Text))//Variable
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == " ")
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else
                            {
                                Result += cellsParts[i][0].Text;
                            }
                        }
                        else
                        {

                            Result += "(";
                            Result += Translate(cellsParts[i], level + 1);
                            Result += ")";
                        }

                    }
                    Result += ")";
                }
                else if (cellsParts[0][0].Text == "{}")
                {

                    if (cellsParts.Count == 1)
                    {
                        return "";
                    }
                    Result += "{";

                    for (int i = 1; i < cellsParts.Count; i++)
                    {
                        if (cellsParts[i].Count == 1)
                        {
                            if (isNumber(cellsParts[i][0].Text))//number
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (isVarible(cellsParts[i][0].Text))//Variable
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == " ")
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else
                            {
                                Result += cellsParts[i][0].Text;
                            }
                        }
                        else
                        {

                            Result += "(";
                            Result += Translate(cellsParts[i], level + 1);
                            Result += ")";
                        }

                    }
                    Result += "}";
                }
                else if (cellsParts[0][0].Text == "")
                {

                    //add nothing for blank charachter

                }
                else if (isFunction(cellsParts[0][0].Text))
                {

                    string s1 = cellsParts[0][0].Text.Remove(cellsParts[0][0].Text.Length - 2);

                    Result += s1 + "(";
                    for (int i = 1; i < cellsParts.Count; i++)
                    {
                        if (cellsParts[i].Count == 1)
                        {
                            if (isNumber(cellsParts[i][0].Text))//number
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (isVarible(cellsParts[i][0].Text))//Variable
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == " ")
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else
                            {
                                Result += cellsParts[i][0].Text;
                            }
                        }
                        else
                        {

                            Result += "(";
                            Result += Translate(cellsParts[i], level + 1);
                            Result += ")";
                        }

                        if (i == cellsParts.Count - 1)
                        {
                            Result += ")";
                        }
                        else
                            Result += ",";
                    }
                }
                else if (cellsParts.Count == 2 && cellsParts[0].Count == 1 && cellsParts[1].Count == 1 && isVarible(cellsParts[0][0].Text) && (isVarible(cellsParts[1][0].Text) || isNumber(cellsParts[1][0].Text)))
                {
                    Result += cellsParts[0][0].Text + cellsParts[1][0].Text;
                }
                else
                {
                    for (int i = 0; i < cellsParts.Count; i++)
                    {
                        if (cellsParts[i].Count == 1)
                        {
                            if (isNumber(cellsParts[i][0].Text))//number
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (isVarible(cellsParts[i][0].Text))//Variable
                            {
                                Result += cellsParts[i][0].Text;
                            }
                            else if (cellsParts[i][0].Text == " ")
                            {
                                Result += "";
                            }
                            else
                            {
                                Result += cellsParts[i][0].Text;
                            }
                        }
                        else
                        {

                            Result += "(";
                            Result += Translate(cellsParts[i], level + 1);
                            Result += ")";
                        }

                    }
                }
            }
            else
            {
                for (int i = 0; i < cellsParts.Count; i++)
                {
                    if (cellsParts[i].Count == 1)
                    {
                        if (isNumber(cellsParts[i][0].Text))//number
                        {
                            Result += cellsParts[i][0].Text;
                        }
                        else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                        {
                            Result += cellsParts[i][0].Text;
                        }
                        else if (isVarible(cellsParts[i][0].Text))//Variable
                        {
                            Result += cellsParts[i][0].Text;
                        }
                        else if (cellsParts[i][0].Text == " ")
                        {
                            Result += "";
                        }
                        else
                        {
                            Result += cellsParts[i][0].Text;
                        }
                    }
                    else
                    {

                        Result += "(";
                        Result += Translate(cellsParts[i], level + 1);
                        Result += ")";
                    }

                }
            }


            return Result;
        }
        private static Boolean isNumber(string s)
        {
            Double d;
            if (Double.TryParse(s, out d))
            {
                return true;
            }
            return false;
        }
        private static Boolean isVarible(string s)
        {
            for (int i = 0; i < s.Length; i++)
            {
                if (!Char.IsLetter(s[i]))
                    return false;
            }
            return true;
        }
        private static Boolean isFunction(string s)
        {
            if (s.Length > 2)
                return (s.EndsWith("()") && isVarible(s.Remove(s.Length - 2)));
            return false;
        }


    }
}
