﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using DevComponents.DotNetBar.Controls;
namespace MathTextBox
{
    [Serializable]
    public partial class TextBoxY : ReflectionLabel
    {
        private int caretIndex = 0;
        private string text1 = "";
        private Char caretChar = '|';
        private bool caretFlashing = true;
        private TextModeType textMode = TextModeType.Number;
        private int d = 0;
        private bool autoSize1 = true;
        public enum TextModeType
        {
            Number,
            Letter,
            LetterOrNumber
        }
        public TextBoxY()
        {
            this.BackgroundStyle.PaddingTop = this.BackgroundStyle.PaddingBottom = 0;
            InitializeComponent();
            this.Font =new Font(Font.FontFamily,16);
            if (AutoSizeText)
            {

                if (this.ReflectionEnabled)
                    base.Height = Convert.ToInt32(TextRenderer.MeasureText((this.Text == "" ? " " : this.Text), new Font(Font.FontFamily, Font.Size)).Height * (1.3));
                else
                    base.Height = Convert.ToInt32(TextRenderer.MeasureText((this.Text == "" ? " " : this.Text), new Font(Font.FontFamily, Font.Size)).Height);
                base.Width = TextRenderer.MeasureText((this.Text == "" ? " " : this.Text), new Font(Font.FontFamily, Font.Size)).Width + (this.BackgroundStyle.PaddingLeft + this.BackgroundStyle.PaddingRight) + (Int32)(d / 1.5) - 5;
            }
        }
        protected  void rePaint()
        {


            if (AutoSizeText)
            {
                
                if(this.ReflectionEnabled)
                    base.Height = Convert.ToInt32(TextRenderer.MeasureText((this.Text == "" ? " " : this.Text), new Font(Font.FontFamily, Font.Size)).Height*(1.3));
                else
                    base.Height = Convert.ToInt32(TextRenderer.MeasureText((this.Text == "" ? " " : this.Text), new Font(Font.FontFamily, Font.Size)).Height);
                base.Width = TextRenderer.MeasureText((this.Text == "" ? " " : this.Text), new Font(Font.FontFamily, Font.Size)).Width + (this.BackgroundStyle.PaddingLeft + this.BackgroundStyle.PaddingRight) + (Int32)(d / 1.5) ;
            }
            
            base.ResizeRedraw = true;
            

            
            
            
        }
        
        public int CaretIndex
        {
            set
            {
                int v = value;
                if (v > this.Text.Length)
                {
                    v = this.Text.Length;
                }

                if (v < 0)
                {
                    v = 0;
                }

                this.caretIndex = v;

                refreshCaret();
            }
            get
            {
                return this.caretIndex;
            }
        }

        public string Text
        {
            set
            {
                text1 = value;
                refreshCaret();//just for showing text
                base.Refresh();
            }
            get
            {
                return text1;
            }
        }

        public TextModeType TextMode
        {
            set
            {
                textMode = value;
            }
            get
            {
                return textMode;
            }
        }

        public Boolean AutoSizeText
        {
            set
            {
                autoSize1 = value;
            }
            get
            {
                return autoSize1; 
            }
        }
       
        //private methodes
        
        private void showCaret()
        {

            d = TextRenderer.MeasureText("|", new Font(Font.FontFamily, Font.Size)).Width;
            caretFlashing = true;
            caretTimer.Start();

        }

        private void hideCaret()
        {
            
            caretTimer.Stop();
            base.Text = "<font ><b>" + this.Text + "</b></font>";
            rePaint();
            d = 0;
        }

        private int caretIndexMouseDown(Double d)
        {
            Double lastD= 0,currentD =0,D = d;
            for (int i =0; i < this.Text.Length; i++)
            {
                currentD = TextRenderer.MeasureText(this.Text.Substring(0, i), new Font(Font.FontFamily, Font.Size)).Width ;
                D = d - this.BackgroundStyle.PaddingLeft;
                if (currentD >= D)
                {
                    if (Math.Abs(currentD - D) < Math.Abs(lastD - D))
                        return i + 1;
                    else
                        return i;
                }
                lastD = currentD;
            }
            return this.Text.Length;
        }

        private void refreshCaret()//shows caret or no caret also shows text when unfocused
        {
            if (Focused)
            {
                string s1 = "";
                string s2 = "";
                if (this.Text != "")
                {
                    s1 = this.Text.Substring(0, caretIndex);
                    s2 = this.Text.Substring(CaretIndex, this.Text.Length - CaretIndex);
                }

                if (caretFlashing)
                {
                    base.Text = "<font><b>" + s1 + "</b><font color=\"#B02B2C\">" + caretChar.ToString() + "</font><font><b>" + s2 + "</b></font></font>";
                }
                else
                    base.Text = "<font><b>" + s1 + "</b><font color=\"#B02B2C\"> </font><font><b>" + s2 + "</b></font></font>";
            }
            else
            {
                base.Text = "<font ><b>" + this.Text + "</b></font>";
            }
            rePaint();
        }
        //events
        public event KeyPressEventHandler KeyPress1;
        public event MouseEventHandler MouseDown1;
        public event KeyEventHandler KeyDown1;
        //event feedbacks

        private void TextBoxY_MouseDown1(object sender, System.Windows.Forms.MouseEventArgs e)
        {
               Double d = e.X;
                CaretIndex = caretIndexMouseDown(d);
                Focus();
            
        }


        private void TextBoxY_KeyDown1(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            if (e.Handled)
                return;
            if (e.Alt)
            {
                if (CaretIndex > 0)
                {
                    CaretIndex = CaretIndex - 1;
                    caretFlashing = true;
                    refreshCaret();
                }
                else
                {
                    SelectNextControl(this, false, true, true, true);
                }
                e.Handled = true;
            }
            else if (e.Control)
            {
                if (CaretIndex < this.Text.Length)
                {
                    CaretIndex = CaretIndex + 1;
                    caretFlashing = true;
                    refreshCaret();
                }
                else
                {
                    SelectNextControl(this, true, true, true, true);
                }
                e.Handled = true;
            }
            /*else if (e.KeyData == Keys.Back)
            {
                if (CaretIndex > 0)
                {
                    CaretIndex -= 1;
                    refreshCaret();
                    this.Text = this.Text.Remove(caretIndex, 1);

                }
            }*/
            rePaint();

        }

        private void TextBoxY_KeyPress1(object sender, System.Windows.Forms.KeyPressEventArgs e)
        {
            Double d;
            if (e.Handled) return;
            if (e.KeyChar == (Char)(Keys.Enter))
                return;
            if (TextMode == TextModeType.Number)
            {
               
                if ((Double.TryParse(this.Text.Insert(caretIndex, e.KeyChar.ToString()), out d)))
                {
                    caretTimer.Stop();//to not show what is happening
                    this.text1 =  this.text1.Insert(CaretIndex, e.KeyChar.ToString());
                    CaretIndex++;
                    caretFlashing = true;
                    refreshCaret();//to refresh imediately
                    caretTimer.Start();
                }
            }
            else if (TextMode== TextModeType.Letter)
            {
                if ((e.KeyChar <= (char)Keys.Z && e.KeyChar >= (char)Keys.A) || (e.KeyChar <= (char)122 && e.KeyChar >= (char)97))
                {
                    caretTimer.Stop();//to not show what is happening
                    this.text1 = this.text1.Insert(CaretIndex, e.KeyChar.ToString());
                    caretIndex++;
                    caretFlashing = true;
                    refreshCaret();//to refresh imediately
                    caretTimer.Start();
                }
            }
            else
            {
                if ((e.KeyChar <= (char)Keys.Z && e.KeyChar >= (char)Keys.A) || (e.KeyChar <= (char)122 && e.KeyChar >= (char)97) || (e.KeyChar <= (char)57 && e.KeyChar >= (char)48))
                {
                    caretTimer.Stop();//to not show what is happening
                    this.text1 = this.text1.Insert(CaretIndex, e.KeyChar.ToString());
                    caretIndex++;
                    caretFlashing = true;
                    refreshCaret();//to refresh imediately
                    caretTimer.Start();
                }
            }
            rePaint();
        }

        private void TextBoxY_Enter(object sender, System.EventArgs e)
        {
            
            
            showCaret();
            
        }

        private void TextBoxY_Leave(object sender, System.EventArgs e)
        {
            
            
            
            hideCaret();
        }

        private void TextBoxY_LostFocus(object sender, EventArgs e)
        {
           
        }

        private void TextBoxY_Validated(object sender, EventArgs e)
        {
           
        }
        private void caretTimer_Tick(object sender, EventArgs e)
        {
            refreshCaret();



            caretFlashing = !caretFlashing;
        }

        

        

        
    }
}
