﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MathTextBox
{
    public partial class StatmentWithAnswer : UserControl
    {
        public List<ComboBox> AnsComboBoxes = new List<ComboBox>();
        public StatmentWithAnswer()
        {
            InitializeComponent();
        }
        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);
        }
        protected override void OnVisibleChanged(EventArgs e)
        {
            this.AutoSize = true;
            tableLayoutPanel.AutoSize = true;
            mathStatment.AutoSize = true;
            AnswerPanel.Dock = DockStyle.Fill;
            
            base.OnVisibleChanged(e);
        }
        private void MathStatment1_AnswerChanged(object sender, System.EventArgs e)
        {
            if (mathStatment.items != AnsComboBoxes.Count)
            {
                AnswerPanel.Controls.Clear();
                AnsComboBoxes.Clear();
                for (int i = 0; i < mathStatment.items; i++)
                {
                    ComboBox C = new ComboBox();
                    C.Font = new Font(C.Font.FontFamily, 12);
                    C.DropDownStyle = ComboBoxStyle.DropDownList;
                    C.Width = 178;
                    C.Anchor = AnchorStyles.None;
                    C.BackColor = Color.FromArgb(23, 23, 23);
                    C.ForeColor = Color.White;
                    C.SelectedIndexChanged += new EventHandler(C_SelectedIndexChanged);
                    AnswerPanel.Controls.Add(C);
                    AnsComboBoxes.Add(C);
                }
            }
            AnswerPanel.RowCount = mathStatment.RowCount;
            AnswerPanel.RowStyles.Clear();
            for( int i =0; i< mathStatment.items;i++)
            {
                AnswerPanel.RowStyles.Add(new RowStyle(SizeType.Absolute, mathStatment.GetRowHeights()[i] - 1));

            }
           
            List<String> Expressions = new List<string>();
            foreach(MathTextManager TM in mathStatment.TextManagers)
            {
                Expressions.Add(Translator.Translate(TM.Cells, 0));
            }
            MathNamespace.Calculate.RecognizeAndCalculate(ref Expressions);
            
            for(int i=0;i < AnsComboBoxes.Count; i++)
            {
                AnsComboBoxes[i].Items.Clear();
                AnsComboBoxes[i].Items.AddRange(Expressions[i].Split('\n'));
                AnsComboBoxes[i].Items.RemoveAt(AnsComboBoxes[i].Items.Count - 1);
                if (AnsComboBoxes[i].Items.Count > 0)
                {
                    AnsComboBoxes[i].SelectedIndex = 0;
                    string s = (AnsComboBoxes[i].SelectedItem.ToString());
                    toolTip1.SetToolTip(AnsComboBoxes[i],s);
                }
                else
                {
                    toolTip1.SetToolTip(AnsComboBoxes[i],"No Answer");
                }
            }
            
        }

        private void C_SelectedIndexChanged(object sender, EventArgs e)
        {
            string s = ((ComboBox)sender).SelectedItem.ToString();
            toolTip1.SetToolTip((Control)sender, (s.Trim()==""?"No Answer":s));
        }
    }
}
