﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using DevComponents.DotNetBar.Ribbon;
using DevComponents.DotNetBar.Controls;
using MathNamespace;
namespace MathTextBox
{
  
    public partial class MathTextCell : TableLayoutPanel
    {
        
        private Boolean hoverChangerColor = true;
        private float fontReduce = 0;
        private static string selectedTextBoxIndex;
        private static int selectedTextBoxCaretIndex;
        private static TextBoxY selectedTextbox;
        private List<SubordinateCell> internalList;
        private int lev;
        private int width = 0, height = 0;
        public static Color NumberColor = Color.FromArgb(255, 165, 20, 20);
        public static Color VariableColor = Color.FromArgb(255,45,145,175);
        public static Color FunctionColor = Color.FromArgb(255,45,145,175);
        
        public MathTextCell()
        {
            InitializeComponent();
            
        }
        public static void SetDoubleBuffered(System.Windows.Forms.Control c)
        {
            if (System.Windows.Forms.SystemInformation.TerminalServerSession)
                return;
            System.Reflection.PropertyInfo aProp = typeof(System.Windows.Forms.Control).GetProperty("DoubleBuffered", System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Instance);
            aProp.SetValue(c, true, null);
        }
        public static TextBoxY SelectedTextBox
        {
            set
            {
                selectedTextbox = value;
            }
            get
            {
                return selectedTextbox;
            }
        }
        public Boolean HoverEffect
        {
            set
            {
                hoverChangerColor = value;
            }
            get
            {
                return hoverChangerColor;
            }
        }
        public static String SelectedTextBoxIndex
        {
            set
            {
                selectedTextBoxIndex = value;
            }
            get
            {
                return selectedTextBoxIndex;
            }
        }

        public static Int32 SelectedTextBoxCaretIndex
        {
            set
            {
                selectedTextBoxCaretIndex = value;
            }
            get
            {
                return selectedTextBoxCaretIndex;
            }
        }
        
        protected override void OnPaint(PaintEventArgs pe)
        {
            
            base.OnPaint(pe);
        }
        
        protected override CreateParams CreateParams
        {
            get
            {
                var parms = base.CreateParams;
                parms.Style &= ~0x02000000;
                return parms;
            }
        }
        
        public void refreshAnswer()
        {
            string tS = Translator.Translate(internalList, lev);
            string s = Calculate.RecognizeAndCalculate(tS);
            DevComponents.DotNetBar.SuperTooltipInfo STI = new DevComponents.DotNetBar.SuperTooltipInfo();
            STI.HeaderText = this.Text = "<font color=\"#B02B2C\"><b>Ans :</b></font>";
            STI.BodyText = s;
            superTooltip1.SetSuperTooltip(this, STI);

            foreach(Control C in this.Controls)
            {
                if(C.GetType() == typeof(MathTextCell))
                {
                    ((MathTextCell)C).refreshAnswer();
                }
            }
            
        }
        public Boolean setExpression(List<SubordinateCell> cells, MathTextManager prnt, int level,ref int w,ref int h)
        {

            internalList = cells;
            lev = level;
            string tS = Translator.Translate(cells, level);
            string s = Calculate.RecognizeAndCalculate(tS);
            DevComponents.DotNetBar.SuperTooltipInfo STI = new DevComponents.DotNetBar.SuperTooltipInfo();
            STI.HeaderText = this.Text = "<font color=\"#B02B2C\"><b>Ans :</b></font>";
            STI.BodyText = s;
            superTooltip1.SetSuperTooltip(this,STI);
            


            SetDoubleBuffered(this);
            this.SuspendLayout();
            
            fontReduce = 7 - (float)(Math.Pow(0.7, Convert.ToDouble(level))*7);

            string a = selectedTextBoxIndex;
            int b = SelectedTextBoxCaretIndex;
            this.Controls.Clear();
            SelectedTextBoxIndex = a;
            SelectedTextBoxCaretIndex = b;//because this.Controls.Clear() resets this values
            this.RowStyles.Clear();
            this.ColumnStyles.Clear();
            this.RowCount = 0;
            this.ColumnCount = 0;
            width = 0;
            height = 0;
            
            //this.AutoSize = true;

            int MaxIndex = int.MinValue;
            for (int i = 0; i < cells.Count; i++)
            {
                int d = Convert.ToInt32(cells[i].Index.Split(',')[level]);
                if (d > MaxIndex)
                    MaxIndex = d;
            }


            List<List<SubordinateCell>> cellsParts = new List<List<SubordinateCell>>();
            for (int i = 0; i <= MaxIndex; i++)
            {
                List<SubordinateCell> cellsPart = new List<SubordinateCell>();
                for (int j = 0; j < cells.Count; j++)
                {
                    int d = Convert.ToInt32(cells[j].Index.Split(',')[level]);
                    if (d == i)
                    {
                        cellsPart.Add(cells[j]);
                    }
                }
                cellsParts.Add(cellsPart);
            }

            if (cellsParts.Count == 0)
                return false;



           


            if (cellsParts.Count == 3 && cellsParts[1].Count == 1 && cellsParts[1][0].Text == "/")
            {
                this.GrowStyle = TableLayoutPanelGrowStyle.AddColumns;
                
                this.ColumnCount = 1;
                this.GrowStyle = TableLayoutPanelGrowStyle.AddRows;

                
                
                if (cellsParts[0].Count == 1)
                {
                    if (isNumber(cellsParts[0][0].Text))//number
                    {
                        this.AddToNextRow(0, cellsParts[0][0].Text, cellsParts[0][0].Index, prnt, false);
                    }
                    else if (cellsParts[0][0].Text == "*" || cellsParts[0][0].Text == "/" || cellsParts[0][0].Text == "+" || cellsParts[0][0].Text == "-")//operator
                    {
                        this.AddToNextRow(2, cellsParts[0][0].Text, cellsParts[0][0].Index, prnt, false);
                    }
                    else if (isVarible(cellsParts[0][0].Text))//Variable
                    {
                        this.AddToNextRow(3, cellsParts[0][0].Text, cellsParts[0][0].Index, prnt, false);
                    }
                    else if (cellsParts[0][0].Text == " ")
                    {
                        this.AddToNextRow(0, "", cellsParts[0][0].Index, prnt, false);
                    }
                    {
                        //Don't Show That
                    }
                }
                else
                {
                    int w1=0, h1=0;
                    MathTextCell MTC1 = new MathTextCell();
                    
                    this.RowCount += 1;
                    
                    MTC1.setExpression(cellsParts[0], prnt, level + 1,ref w1,ref h1);
                    MTC1.Anchor = AnchorStyles.None;
                    this.RowStyles.Add(new RowStyle(SizeType.Absolute,h1));
                    height += h1;
                    if (w1 > width)
                        width = w1;
                    this.Controls.Add(MTC1, 0, this.RowCount - 1);
                }
                

                //MessageBox.Show(this.Width.ToString());
                this.GrowStyle = TableLayoutPanelGrowStyle.AddRows;

                Label Lbl = new Label();
                Lbl.Text = "";
                //Lbl.AutoSizeText = false;
                Lbl.Height = 1;
                Lbl.Width = 0;
                Lbl.Enabled = false;
                Lbl.Cursor = Cursors.Arrow;
                Lbl.BackColor = Color.Gray;
                Lbl.Tag = cellsParts[1][0].Index;
                Lbl.MinimumSize = new Size(TextRenderer.MeasureText("23", new Font(Font.FontFamily, 16 - fontReduce)).Width, 0);
                Lbl.Margin = new Padding(0, 0, 0, 0);
                this.RowStyles.Add(new RowStyle(SizeType.Absolute, Lbl.Height));
                height += Lbl.Height;
                if (Lbl.Width > width)
                    width = Lbl.Width;

                Lbl.Dock = DockStyle.Fill;
                this.RowCount += 1;
                this.Controls.Add(Lbl, 0, this.RowCount - 1);
                

                this.GrowStyle = TableLayoutPanelGrowStyle.AddRows;

                if (cellsParts[2].Count == 1)
                {
                    if (isNumber(cellsParts[2][0].Text))//number
                    {
                        this.AddToNextRow(0, cellsParts[2][0].Text, cellsParts[2][0].Index, prnt, false);
                    }
                    else if (cellsParts[2][0].Text == "*" || cellsParts[2][0].Text == "/" || cellsParts[2][0].Text == "+" || cellsParts[2][0].Text == "-")//operator
                    {
                        this.AddToNextRow(2, cellsParts[2][0].Text, cellsParts[2][0].Index, prnt, false);
                    }
                    else if (isVarible(cellsParts[2][0].Text))//Variable
                    {
                        this.AddToNextRow(3, cellsParts[2][0].Text, cellsParts[2][0].Index, prnt, false);
                    }
                    else if (cellsParts[2][0].Text == " ")
                    {
                        this.AddToNextRow(0, "", cellsParts[2][0].Index, prnt, false);
                    }
                    {
                        //Don't Show That
                    }
                }
                else
                {
                    int w1 = 0, h1 = 0;
                    MathTextCell MTC1 = new MathTextCell();

                    this.RowCount += 1;

                    MTC1.setExpression(cellsParts[2], prnt, level + 1, ref w1, ref h1);
                    MTC1.Anchor = AnchorStyles.None;
                    this.RowStyles.Add(new RowStyle(SizeType.Absolute, h1));
                    height += h1;
                    if (w1 > width)
                        width = w1;
                    this.Controls.Add(MTC1, 0, this.RowCount - 1);
                }

                this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute,width));
            }
            else if (cellsParts[0].Count == 1)
            {
                if (cellsParts[0][0].Text == "()")
                {
                    if (cellsParts.Count == 1)
                    {
                        return false;
                    }
                    this.GrowStyle = TableLayoutPanelGrowStyle.AddRows;
                    this.RowCount = 1;
                   
                    this.GrowStyle = TableLayoutPanelGrowStyle.AddColumns;


                    this.AddToNextColumn(1, "(",cellsParts[0][0].Index, prnt, false);
                    TextBoxY tby;
                    for (int i = 1; i < cellsParts.Count; i++)
                    {
                        if (cellsParts[i].Count == 1)
                        {
                            if (isNumber(cellsParts[i][0].Text))//number
                            {
                                tby=this.AddToNextColumn(0, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                                tby.Anchor = AnchorStyles.None;
                            }
                            else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                            {
                                tby=this.AddToNextColumn(2, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                                tby.Anchor = AnchorStyles.None;
                            }
                            else if (isVarible(cellsParts[i][0].Text))//Variable
                            {
                                tby=this.AddToNextColumn(3, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                                tby.Anchor = AnchorStyles.None;
                            }
                            else if (cellsParts[i][0].Text == " ")
                            {
                                tby=this.AddToNextColumn(0, "", cellsParts[i][0].Index, prnt, false);
                                tby.Anchor = AnchorStyles.None;
                            }
                            {
                                //Don't Show That
                            }
                        }
                        else
                        {
                            int w1 = 0, h1 = 0;
                            MathTextCell MTC1 = new MathTextCell();

                            this.ColumnCount += 1;

                            MTC1.setExpression(cellsParts[i], prnt, level + 1, ref w1, ref h1);
                            MTC1.Anchor = AnchorStyles.None;
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                            width += w1;
                            if (h1 > height)
                                height = h1;
                            this.Controls.Add(MTC1, ColumnCount - 1, 0);

                        }

                    }
                    this.AddToNextColumn(1, ")", cellsParts[0][0].Index, prnt, false);

                    this.RowStyles.Add(new RowStyle(SizeType.AutoSize));
                }
                else if (cellsParts[0][0].Text == "{}")
                {

                    if (cellsParts.Count == 1)
                    {
                        return false;
                    }

                    this.GrowStyle = TableLayoutPanelGrowStyle.AddRows;
                    this.RowCount = 1;
                    
                    this.GrowStyle = TableLayoutPanelGrowStyle.AddColumns;


                    this.AddToNextColumn(4, "Repeat", cellsParts[0][0].Index, prnt, false);
                    this.AddToNextColumn(1, "(", cellsParts[0][0].Index, prnt, false);
                    for (int i = 1; i < cellsParts.Count; i++)
                    {
                        if (cellsParts[i].Count == 1)
                        {
                            if (isNumber(cellsParts[i][0].Text))//number
                            {
                                this.AddToNextColumn(0, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                            }
                            else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                            {
                                this.AddToNextColumn(2, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                            }
                            else if (isVarible(cellsParts[i][0].Text))//Variable
                            {
                                this.AddToNextColumn(3, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                            }
                            else if (cellsParts[i][0].Text == " ")
                            {
                                this.AddToNextColumn(0, "", cellsParts[i][0].Index, prnt, false);
                            }
                            {
                                //Don't Show That
                            }
                        }
                        else
                        {
                            int w1 = 0, h1 = 0;
                            MathTextCell MTC1 = new MathTextCell();

                            this.ColumnCount += 1;

                            MTC1.setExpression(cellsParts[i], prnt, level + 1, ref w1, ref h1);
                            MTC1.Anchor = AnchorStyles.None;
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                            width += w1;
                            if (h1 > height)
                                height = h1;
                            this.Controls.Add(MTC1, ColumnCount - 1, 0);
                        }

                    }
                    this.AddToNextColumn(1, ")",cellsParts[0][0].Index, prnt, false);
                    this.RowStyles.Add(new RowStyle(SizeType.Absolute,height));
                }
                else if (cellsParts[0][0].Text == "")
                {



                    this.GrowStyle = TableLayoutPanelGrowStyle.AddRows;
                    this.RowCount = 1;
                    
                    this.GrowStyle = TableLayoutPanelGrowStyle.AddColumns;


                    this.AddToNextColumn(3, "End", cellsParts[0][0].Index, prnt, false);
                    this.RowStyles.Add(new RowStyle(SizeType.Absolute, height));


                }
                else if (isFunction(cellsParts[0][0].Text))
                {
                    int functionType = 0;
                    string s1 = cellsParts[0][0].Text.Remove(cellsParts[0][0].Text.Length - 2);
                    int startI = 1;
                    if (s1 == "Sqrt" && cellsParts.Count == 2)
                    {

                        this.GrowStyle = TableLayoutPanelGrowStyle.AddRows;
                        this.RowCount = 2;
                        this.GrowStyle = TableLayoutPanelGrowStyle.AddColumns;
                        this.ColumnCount = 2;
                        int a1 = TextRenderer.MeasureText("√", new Font(Font.FontFamily, 16 - fontReduce)).Width;

                        this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute,a1));
                        this.RowStyles.Add(new RowStyle(SizeType.Absolute,2));
                        



                        Label Lbl1 = new Label();
                        Lbl1.Text = "";
                        //Lbl.AutoSizeText = false;
                        Lbl1.Height = 2;
                        Lbl1.Width = 0;
                        Lbl1.Enabled = false;
                        Lbl1.Cursor = Cursors.Arrow;
                        Lbl1.BackColor = Color.Gray;
                        Lbl1.Tag = cellsParts[1][0].Index;
                        //Lbl1.MinimumSize = new Size(TextRenderer.MeasureText("23", new Font(Font.FontFamily, 16 - fontReduce)).Width, 0);
                        Lbl1.Margin = new Padding(0, 0, 0, 0);
                        //this.RowStyles.Add(new RowStyle(SizeType.Absolute, Lbl1.Height));
                        //height += Lbl1.Height;
                        //if (Lbl1.Width > width)
                        // width = Lbl1.Width;

                        Lbl1.Dock = DockStyle.Fill;
                        this.RowCount += 1;
                        this.Controls.Add(Lbl1, 1, 0);
                        height += 2;

                        

                        if (cellsParts[1].Count == 1)
                        {
                            TextBoxY TBY1 = null;
                            if (isNumber(cellsParts[1][0].Text))//number
                            {
                                TBY1=this.AddToNextColumn(0, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, true, 1, 1);
                                
                            }
                            else if (cellsParts[1][0].Text == "*" || cellsParts[1][0].Text == "/" || cellsParts[1][0].Text == "+" || cellsParts[1][0].Text == "-")//operator
                            {
                                TBY1 = this.AddToNextColumn(2, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, true, 1, 1);
                            }
                            else if (isVarible(cellsParts[1][0].Text))//Variable
                            {
                                TBY1 = this.AddToNextColumn(3, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, true, 1, 1);
                            }
                            else if (cellsParts[1][0].Text == " ")
                            {
                                TBY1 = this.AddToNextColumn(0, "", cellsParts[1][0].Index, prnt, true, 1, 1);
                            }
                            {
                                //Don't Show That
                            }
                            if(TBY1 != null)
                            {
                                this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute,TBY1.Width));
                                this.RowStyles.Add(new RowStyle(SizeType.Absolute,TBY1.Height));
                            }
                        }
                        else
                        {
                            int w1 = 0, h1 = 0;
                            MathTextCell MTC1 = new MathTextCell();

                            this.ColumnCount += 1;

                            MTC1.setExpression(cellsParts[1], prnt, level + 1, ref w1, ref h1);
                            MTC1.Anchor = AnchorStyles.None;
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                            this.RowStyles.Add(new RowStyle(SizeType.Absolute, h1));
                            width += w1 ;
                            height += h1;
                            this.Controls.Add(MTC1, 1, 1);
                        }



                        this.AddToNextColumn(1, "√", cellsParts[0][0].Index, prnt, true, 0, 1);



                        functionType = 1;
                        startI = 2;
                    }
                    else if (s1 == "Log" && cellsParts.Count == 3)
                    {
                        this.AddToNextColumn(4, s1, cellsParts[0][0].Index, prnt, false);
                        this.AddToNextColumn(1, "(", cellsParts[0][0].Index, prnt, false);
                    }
                    else if (s1 == "Factorial" && cellsParts.Count == 2)
                    {
                        if (cellsParts[1].Count == 1)
                            functionType = 2;
                        else
                        {
                            functionType = 3;
                            this.AddToNextColumn(1, "(",cellsParts[0][0].Index, prnt, false);
                        }
                    }
                    else if(s1 == "Pow" && cellsParts.Count == 3)
                    {
                        int PH = 0, PW = 0 ;


                        functionType = 1;
                        startI = 3;

                        this.RowCount += 2;
                        this.ColumnCount += 2;

                        
                        TextBoxY TBY = new TextBoxY();
                        if (cellsParts[1].Count == 1)
                        {
                            if (isNumber(cellsParts[1][0].Text))//number
                            {
                                 TBY = this.AddToNextColumn(0, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, false,0,1);
                                
                            }
                            else if (cellsParts[1][0].Text == "*" || cellsParts[1][0].Text == "/" || cellsParts[1][0].Text == "+" || cellsParts[1][0].Text == "-")//operator
                            {
                                TBY = this.AddToNextColumn(2, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, false,0,1);
                            }
                            else if (isVarible(cellsParts[1][0].Text))//Variable
                            {
                                TBY = this.AddToNextColumn(3, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, false,0,1);
                            }
                            else if (cellsParts[1][0].Text == " ")
                            {
                                TBY = this.AddToNextColumn(0, "", cellsParts[1][0].Index, prnt, false,0,1);
                            }
                            {
                                //Don't Show That
                            }
                        }
                        else
                        {
                            int w1 = 0, h1 = 0;
                            MathTextCell MTC1 = new MathTextCell();

                            this.ColumnCount += 1;

                            MTC1.setExpression(cellsParts[1], prnt, level + 1, ref w1, ref h1);
                            MTC1.Anchor = AnchorStyles.None;
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                            PH += h1;
                            PW += w1;
                            

                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, MTC1.Width));
                            this.RowStyles.Add(new RowStyle(SizeType.Absolute, MTC1.Height));

                            this.Controls.Add(MTC1, 0, 1);
                        }
                        TextBoxY tBY1 = null;
                        if (cellsParts[2].Count == 1)
                        {
                            if (isNumber(cellsParts[2][0].Text))//number
                            {
                               tBY1= this.AddToNextColumn(0, cellsParts[2][0].Text, cellsParts[2][0].Index, prnt, false,1,0,13);
                                tBY1.ReflectionEnabled = false;
                                tBY1.Anchor = AnchorStyles.None;
                                tBY1.BackgroundStyle.PaddingLeft = 0;

                                
                            }
                            else if (cellsParts[2][0].Text == "*" || cellsParts[2][0].Text == "/" || cellsParts[2][0].Text == "+" || cellsParts[2][0].Text == "-")//operator
                            {
                                tBY1 = this.AddToNextColumn(2, cellsParts[2][0].Text, cellsParts[2][0].Index, prnt, false,1,0,13);
                                tBY1.ReflectionEnabled = false;
                            }
                            else if (isVarible(cellsParts[2][0].Text))//Variable
                            {
                                tBY1 = this.AddToNextColumn(3, cellsParts[2][0].Text, cellsParts[2][0].Index, prnt, false,1,0,13);
                                tBY1.ReflectionEnabled = false;
                            }
                            else if (cellsParts[2][0].Text == " ")
                            {
                                tBY1 = this.AddToNextColumn(0, "", cellsParts[2][0].Index, prnt, false,1,0,13);
                                tBY1.ReflectionEnabled = false;
                            }
                            {
                                //Don't Show That
                            }
                        }
                        else
                        {
                            int w1 = 0, h1 = 0;
                            MathTextCell MTC1 = new MathTextCell();

                            this.ColumnCount += 1;

                            MTC1.setExpression(cellsParts[2], prnt, level + 1, ref w1, ref h1);
                            MTC1.Anchor = AnchorStyles.None;
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                            PH += h1;
                            PW += w1;
                            

                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute,MTC1.Width));
                            this.RowStyles.Add(new RowStyle(SizeType.Absolute, MTC1.Height));

                            this.Controls.Add(MTC1, 1, 0);
                        }

                        if (TBY != null && tBY1 != null)
                        {
                            PH += TBY.Height;
                            PH += tBY1.Height;

                            PW += TBY.Width;
                            PW += tBY1.Width;

                        }

                        if(TBY != null)
                        {
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, TBY.Width));
                        }

                        if(tBY1!= null)
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute , tBY1.Width));

                        if (tBY1 != null)
                            this.RowStyles.Add(new RowStyle(SizeType.Absolute,tBY1.Height));
                        if (TBY != null)
                        {
                            this.RowStyles.Add(new RowStyle(SizeType.Absolute, TBY.Height));
                        }
                       

                        width += PW;
                        if (height < PH)
                            height = PH;


                    }
                    else
                    {
                        this.AddToNextColumn(4,cellsParts[0][0].Text.Remove(cellsParts[0][0].Text.Length - 2), cellsParts[0][0].Index, prnt, false);
                        this.AddToNextColumn(1, "(", cellsParts[0][0].Index, prnt, false);
                    }

                        for (int i = startI; i < cellsParts.Count; i++)
                        {
                            if (cellsParts[i].Count == 1)
                            {
                                if (isNumber(cellsParts[i][0].Text))//number
                                {
                                    this.AddToNextColumn(0, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                                }
                                else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                                {
                                    this.AddToNextColumn(2, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                                }
                                else if (isVarible(cellsParts[i][0].Text))//Variable
                                {
                                    this.AddToNextColumn(3, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                                }
                                else if (cellsParts[i][0].Text == " ")
                                {
                                    this.AddToNextColumn(0, "", cellsParts[i][0].Index, prnt, false);
                                }
                                {
                                    //Don't Show That
                                }
                            }
                            else
                            {
                            int w1 = 0, h1 = 0;
                            MathTextCell MTC1 = new MathTextCell();

                            this.ColumnCount += 1;

                            MTC1.setExpression(cellsParts[i], prnt, level + 1, ref w1, ref h1);
                            MTC1.Anchor = AnchorStyles.None;
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                            width += w1;
                            if (h1 > height)
                                height = h1;
                            this.Controls.Add(MTC1, ColumnCount - 1, 0);
                            
                        }

                            if (i == cellsParts.Count - 1)
                            {
                                if (functionType == 0)
                                    this.AddToNextColumn(1, ")", cellsParts[0][0].Index, prnt, false);
                                else if (functionType == 2)
                                    this.AddToNextColumn(1, "!", cellsParts[0][0].Index, prnt, false);
                                else if (functionType == 3)
                                    this.AddToNextColumn(1, ")!", cellsParts[0][0].Index, prnt, false);
                            }
                            else
                                this.AddToNextColumn(1, ",", cellsParts[0][0].Index, prnt, false);

                    }
                }
                else if(cellsParts.Count == 2 && isVarible(cellsParts[0][0].Text ) && (isVarible(cellsParts[1][0].Text) || isNumber(cellsParts[1][0].Text)))
                {
                    this.RowCount += 2;
                    this.ColumnCount += 2;
                    this.ColumnStyles.Add(new ColumnStyle(SizeType.AutoSize));
                    this.ColumnStyles.Add(new ColumnStyle(SizeType.AutoSize));


                    this.RowStyles.Add(new RowStyle(SizeType.AutoSize));
                    this.RowStyles.Add(new RowStyle(SizeType.AutoSize));
                    TextBoxY tBY1;
                    if (cellsParts[0].Count == 1)
                    {
                        if (isNumber(cellsParts[0][0].Text))//number
                        {
                            tBY1 = this.AddToNextColumn(0, cellsParts[0][0].Text, cellsParts[0][0].Index, prnt, false, 0, 0);
                            tBY1.ReflectionEnabled = false;
                        }
                        else if (cellsParts[0][0].Text == "*" || cellsParts[0][0].Text == "/" || cellsParts[0][0].Text == "+" || cellsParts[0][0].Text == "-")//operator
                        {
                            tBY1 = this.AddToNextColumn(2, cellsParts[0][0].Text, cellsParts[0][0].Index, prnt, false, 0, 0);
                            tBY1.ReflectionEnabled = false;
                        }
                        else if (isVarible(cellsParts[0][0].Text))//Variable
                        {
                            tBY1 = this.AddToNextColumn(3, cellsParts[0][0].Text, cellsParts[0][0].Index, prnt, false, 0, 0);
                            tBY1.ReflectionEnabled = false;
                        }
                        else if (cellsParts[0][0].Text == " ")
                        {
                            tBY1 = this.AddToNextColumn(0, "", cellsParts[0][0].Index, prnt, false, 0, 0);
                            tBY1.ReflectionEnabled = false;
                        }
                        {
                            //Don't Show That
                        }
                    }
                    else
                    {
                        int w1 = 0, h1 = 0;
                        MathTextCell MTC1 = new MathTextCell();

                        this.ColumnCount += 1;

                        MTC1.setExpression(cellsParts[0], prnt, level + 1, ref w1, ref h1);
                        MTC1.Anchor = AnchorStyles.None;
                        this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                        width += w1;
                        if (h1 > height)
                            height = h1;
                        this.Controls.Add(MTC1,0, 0);
                    }
                    
                    if (cellsParts[1].Count == 1)
                    {
                        if (isNumber(cellsParts[1][0].Text))//number
                        {
                            this.AddToNextColumn(0, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, false, 1, 1, 13);
                            

                        }
                        else if (cellsParts[1][0].Text == "*" || cellsParts[1][0].Text == "/" || cellsParts[1][0].Text == "+" || cellsParts[1][0].Text == "-")//operator
                        {
                            this.AddToNextColumn(2, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, false, 1, 1, 13);
                            
                        }
                        else if (isVarible(cellsParts[1][0].Text))//Variable
                        {
                            this.AddToNextColumn(3, cellsParts[1][0].Text, cellsParts[1][0].Index, prnt, false, 1, 1, 13);
                            
                        }
                        else if (cellsParts[1][0].Text == " ")
                        {
                            this.AddToNextColumn(0, "", cellsParts[1][0].Index, prnt, false, 1, 1, 13);
                            
                        }
                        {
                            //Don't Show That
                        }
                    }
                    else
                    {
                        int w1 = 0, h1 = 0;
                        MathTextCell MTC1 = new MathTextCell();

                        this.ColumnCount += 1;

                        MTC1.setExpression(cellsParts[1], prnt, level + 1, ref w1, ref h1);
                        MTC1.Anchor = AnchorStyles.None;
                        this.RowStyles.Add(new RowStyle(SizeType.Absolute, h1));
                        height += h1;
                        if (w1 > width)
                            width = w1;
                        this.Controls.Add(MTC1, 1, 1);
                    }
                }
                else
                {
                    for (int i = 0; i < cellsParts.Count; i++)
                    {
                        if (cellsParts[i].Count == 1)
                        {
                            if (isNumber(cellsParts[i][0].Text))//number
                            {
                                this.AddToNextColumn(0, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                            }
                            else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                            {
                                this.AddToNextColumn(2, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                            }
                            else if (isVarible(cellsParts[i][0].Text))//Variable
                            {
                                this.AddToNextColumn(3, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                            }
                            else if (cellsParts[i][0].Text == " ")
                            {
                                this.AddToNextColumn(0, "", cellsParts[i][0].Index, prnt, false);
                            }
                            else if (cellsParts[i][0].Text == "<" || cellsParts[i][0].Text == ">" || cellsParts[i][0].Text == "==" || cellsParts[i][0].Text == "=" || cellsParts[i][0].Text == "!=" || cellsParts[i][0].Text == ":" || cellsParts[i][0].Text == "<=" || cellsParts[i][0].Text == ">=" || cellsParts[i][0].Text == ":=")
                            {
                                this.AddToNextColumn(5, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                            }
                            else
                            {
                                //do nothing
                            }
                        }
                        else
                        {
                            int w1 = 0, h1 = 0;
                            MathTextCell MTC1 = new MathTextCell();

                            this.ColumnCount += 1;

                            MTC1.setExpression(cellsParts[i], prnt, level + 1, ref w1, ref h1);
                            MTC1.Anchor = AnchorStyles.None;
                            this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                            width+=w1;
                            if (h1 > height)
                                height = h1;
                            this.Controls.Add(MTC1, ColumnCount - 1, 0);
                        }

                    }
                }
            }
            else
            {
                for (int i = 0; i < cellsParts.Count; i++)
                {
                    if (cellsParts[i].Count == 1)
                    {
                        if (isNumber(cellsParts[i][0].Text))//number
                        {
                            this.AddToNextColumn(0, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                        }
                        else if (cellsParts[i][0].Text == "*" || cellsParts[i][0].Text == "/" || cellsParts[i][0].Text == "+" || cellsParts[i][0].Text == "-")//operator
                        {
                            this.AddToNextColumn(2, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                        }
                        else if (isVarible(cellsParts[i][0].Text))//Variable
                        {
                            this.AddToNextColumn(3, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                        }
                        else if (cellsParts[i][0].Text == " ")
                        {
                            this.AddToNextColumn(0, "", cellsParts[i][0].Index, prnt, false);
                        }
                        else if (cellsParts[i][0].Text == "<" || cellsParts[i][0].Text == ">" || cellsParts[i][0].Text == "==" || cellsParts[i][0].Text == "=" || cellsParts[i][0].Text == "!=" || cellsParts[i][0].Text == ":" || cellsParts[i][0].Text == "<=" || cellsParts[i][0].Text == ">=" || cellsParts[i][0].Text == ":=")
                        {
                            this.AddToNextColumn(5, cellsParts[i][0].Text, cellsParts[i][0].Index, prnt, false);
                        }
                        else
                        {
                            //do nothing
                        }
                    }
                    else
                    {
                        int w1 = 0, h1 = 0;
                        MathTextCell MTC1 = new MathTextCell();

                        this.ColumnCount += 1;

                        MTC1.setExpression(cellsParts[i], prnt, level + 1, ref w1, ref h1);
                        MTC1.Anchor = AnchorStyles.None;
                        this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, w1));
                        width += w1;
                        if (h1 > height)
                            height = h1;
                        this.Controls.Add(MTC1, ColumnCount - 1, 0);
                    }

                }
            }

           


            this.Height = height;
            this.Width = width;
            this.ResumeLayout();

            w = width ;
            h = height;

            return false;
        }

        public  TextBoxY AddToNextColumn(int type , string txt, string indx ,MathTextManager prnt,bool setSize , params int[] ColumnRowFont )
        {
            int c = 0;
            switch (ColumnRowFont.Length)
            {
                case 0:
                    c = 0;
                    break;
                case 2:
                    c = 1;
                    break;
                case 3:
                    c = 2;
                    break;
            }
            TextBoxY tBY1 ;
            if (type == 0 )
            {
                tBY1 = new TextBoxY();
                
                tBY1.Text = txt;
                tBY1.Tag = indx;
                

                tBY1.Margin = new Padding(0,0,0,0);
                tBY1.TextMode = TextBoxY.TextModeType.Number;
                tBY1.ForeColor = NumberColor;
                tBY1.Anchor = AnchorStyles.None;
                if (txt == "")
                {
                    tBY1.TextMode = TextBoxY.TextModeType.LetterOrNumber;
                }
                if (c == 0)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute,tBY1.Width));
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                    
                    this.ColumnCount += 1;
                    this.Controls.Add(tBY1, this.ColumnCount - 1, 0);
                }
                else if (c == 1)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    if (setSize)
                    {
                        width += tBY1.Width;
                        if (height < tBY1.Height)
                            height = tBY1.Height;
                    }
                    
                }
                else if(c == 2)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", ColumnRowFont[2] - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    if (setSize)
                    {
                        width += tBY1.Width;
                        if (height < tBY1.Height)
                            height = tBY1.Height;
                    }
                }
                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
                

            }
            else if(type == 1 || type == 2)
            {
                switch (txt)
                {
                    case "*":
                        {
                            
                            txt = "•";
                            break;
                        }
                }
                tBY1 = new TextBoxY();

                tBY1.Text = txt;
                tBY1.Tag = indx;


                tBY1.Margin = new Padding(0, 0, 0, 0);
                //tBY1.Enabled = false;

                
               tBY1.Anchor = AnchorStyles.None;
                
                
                if (c == 0)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.ColumnCount += 1;
                    this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, tBY1.Width));
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                    
                    
                    this.Controls.Add(tBY1, this.ColumnCount - 1, 0);
                }
                else if (c == 1)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                }
                else if (c == 2)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", ColumnRowFont[2] - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                }
                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
                
            }
            else if(type == 3)
            {

                switch (txt)
                {
                    case "pi":
                        {

                            txt = "π";
                            break;
                        }
                }

                tBY1 = new TextBoxY();

                tBY1.Text = txt;
                tBY1.Tag = indx;
                tBY1.TextMode = TextBoxY.TextModeType.Letter;
                if (txt == "End")
                {
                    tBY1.ForeColor = Color.FromArgb(255, 50,50, 255);
                }
                else
                    tBY1.ForeColor = VariableColor;
                tBY1.Margin = new Padding(0, 0, 0, 0);

                
                tBY1.Anchor = AnchorStyles.None;
                if (c == 0)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, tBY1.Width));
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                    
                    this.ColumnCount += 1;
                    this.Controls.Add(tBY1, this.ColumnCount - 1, 0);
                }
                else if (c == 1)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    if (setSize)
                    {
                        width += tBY1.Width;
                        if (height < tBY1.Height)
                            height = tBY1.Height;
                    }
                }
                else if (c == 2)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", ColumnRowFont[2] - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    if (setSize)
                    {
                        width += tBY1.Width;
                        if (height < tBY1.Height)
                            height = tBY1.Height;
                    }
                }
                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
                
            }
            else if(type == 4)
            {
                tBY1 = new TextBoxY();

                tBY1.Text = txt;
                tBY1.Tag = indx;
                tBY1.TextMode = TextBoxY.TextModeType.Letter;

                if (txt == "Repeat")
                {
                    tBY1.ForeColor = Color.FromArgb(255, 50, 50, 255);
                }
                else
                    tBY1.ForeColor = FunctionColor;

                tBY1.Margin = new Padding(0, 0, 0, 0);
                

                tBY1.Anchor = AnchorStyles.None;
                if (c == 0)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, tBY1.Width));
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                    
                    this.ColumnCount += 1;
                    this.Controls.Add(tBY1, this.ColumnCount - 1, 0);
                }
                else if (c == 1)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                }
                else if (c == 2)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", ColumnRowFont[2] - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                }
                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
                
            }
            else 
            {
                switch (txt)
                {
                    case ":":
                        {
                            txt = "←";
                            break;
                        }
                    case ">=":
                        {
                            txt = "≥";
                            break;
                        }
                    case "<=":
                        {
                            txt = "≤";
                            break;
                        }
                    case "!=":
                        {
                            txt = "≠";
                            break;
                        }
                    case ">":
                        {
                            txt = "˃";
                            break;
                        }
                    case "<":
                        {
                            txt = "˂";
                            break;
                        }
                }
                tBY1 = new TextBoxY();

                tBY1.Text = txt;
                tBY1.Tag = indx;

                tBY1.Enabled = false;
                tBY1.Margin = new Padding(0, 0, 0, 0);

                
                tBY1.Anchor = AnchorStyles.None;
                if (c == 0)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.ColumnStyles.Add(new ColumnStyle(SizeType.Absolute, tBY1.Width));
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                    
                    this.ColumnCount += 1;
                    this.Controls.Add(tBY1, this.ColumnCount - 1, 0);
                }
                else if (c == 1)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                }
                else if (c == 2)
                {
                    tBY1.Font = new Font("Microsoft Sans Serif", ColumnRowFont[2] - fontReduce);
                    this.Controls.Add(tBY1, ColumnRowFont[0], ColumnRowFont[1]);
                    width += tBY1.Width;
                    if (height < tBY1.Height)
                        height = tBY1.Height;
                }
                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
                
            }

            if(tBY1 == null)
            {
                return new TextBoxY();

            }
            else
            {
                if(tBY1.Tag.ToString() == MathTextCell.SelectedTextBoxIndex)
                {
                    tBY1.CaretIndex = MathTextCell.SelectedTextBoxCaretIndex;
                    MathTextCell.SelectedTextBox = null;
                    MathTextCell.SelectedTextBox = tBY1;
                }
                return tBY1;
            }
        }

        

        public void AddToNextRow(int type, string txt, string indx, MathTextManager prnt, bool special)
        {
            TextBoxY tBY1 = new TextBoxY();
            if (type == 0)
            {
                
                tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);
                tBY1.Text = txt;
                tBY1.Tag = indx;
                this.RowCount += 1;

                tBY1.Margin = new Padding(0, 0, 0, 0);
                tBY1.TextMode = TextBoxY.TextModeType.Number;
                
                tBY1.Anchor = AnchorStyles.None;
                if(txt == "")
                {
                    tBY1.TextMode = TextBoxY.TextModeType.LetterOrNumber;
                }
                tBY1.ForeColor = NumberColor;

                this.RowStyles.Add(new RowStyle(SizeType.Absolute, tBY1.Height));
                height += tBY1.Height;
                if (tBY1.Width > width)
                    width = tBY1.Width;
                this.Controls.Add(tBY1, 0, this.RowCount - 1);
                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
                
            }
            else if (type == 1 || type == 2)
            {
                switch (txt)
                {
                    case "*":
                        {

                            txt = "•";
                            break;
                        }
                }
                
                tBY1.Font = new Font("Microsoft Sans Serif", 20 - fontReduce);
                tBY1.Text = txt;
                tBY1.Tag = indx;
                tBY1.Margin = new Padding(0, 0, 0, 0);
               
                //tBY1.Enabled = false;//to be readonly

                this.RowCount += 1;
                this.RowStyles.Add(new RowStyle(SizeType.Absolute,tBY1.Height));
                height += tBY1.Height;
                if (tBY1.Width > width)
                    width = tBY1.Width;
                
                tBY1.Anchor = AnchorStyles.None;
                this.Controls.Add(tBY1, 0, this.RowCount - 1);
                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
            }
            else if (type == 3)
            {

                switch (txt)
                {
                    case "pi":
                        {

                            txt = "π";
                            break;
                        }
                }


                if (special)
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce, FontStyle.Italic);
                else
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);

                tBY1.Text = txt;
                tBY1.Tag = indx;
                tBY1.TextMode = TextBoxY.TextModeType.Letter;
                this.RowCount += 1;
                tBY1.ForeColor = VariableColor;
                tBY1.Margin = new Padding(0, 0, 0, 0);

                this.RowStyles.Add(new RowStyle(SizeType.Absolute, tBY1.Height));
                height += tBY1.Height;
                if (tBY1.Width > width)
                    width = tBY1.Width;

                this.Controls.Add(tBY1,0, this.RowCount - 1);
                tBY1.Anchor = AnchorStyles.None;

                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
            }
            else if (type == 4)
            {
                
                tBY1.Text = txt;
                tBY1.Tag = indx;
                tBY1.Margin = new Padding(0, 0, 0, 0);
                tBY1.ForeColor = FunctionColor;
                tBY1.TextMode = TextBoxY.TextModeType.Letter;
                if (special)
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce, FontStyle.Italic);
                else
                    tBY1.Font = new Font("Microsoft Sans Serif", 16 - fontReduce);





                this.RowCount += 1;
                this.RowStyles.Add(new RowStyle(SizeType.Absolute, tBY1.Height));
                height += tBY1.Height;
                if (tBY1.Width > width)
                    width = tBY1.Width;
                this.Controls.Add(tBY1,0, this.RowCount - 1);
                tBY1.Anchor = AnchorStyles.None;

                tBY1.KeyDown1 += new KeyEventHandler(prnt.TBY_KeyDown);
                tBY1.KeyPress1 += new KeyPressEventHandler(prnt.TBY_KeyPress);
                tBY1.Enter += new EventHandler(prnt.TBY_Enter);
                tBY1.Leave += new EventHandler(prnt.TBY_Leave);
            }
            
                if (tBY1.Tag.ToString() == MathTextCell.SelectedTextBoxIndex)
                {
                    tBY1.CaretIndex = MathTextCell.SelectedTextBoxCaretIndex;
                    MathTextCell.SelectedTextBox = null;
                    MathTextCell.SelectedTextBox = tBY1;
                }
            

        }
        private Boolean isNumber(string s)
        {
            Double d;
            if(Double.TryParse(s,out d))
            {
                return true;
            }
            return false;
        }
         private Boolean isVarible(string s)
        {
            for(int i = 0; i < s.Length; i++)
            {
                if (!Char.IsLetter(s[i]))
                    return false;
            }
            return true;
        }
        private Boolean isFunction(string s)
        {
            if(s.Length > 2)
                return (s.EndsWith("()") && isVarible(s.Remove(s.Length - 2)));
            return false;
        }

        //events

        private void MathTextCell_MouseEnter(object sender, System.EventArgs e)//Changed to Mouse Hover Event
        {
            if (HoverEffect)
            {
                this.BackColor = Color.FromArgb(0x320000FF);
            }
        }
        private void MathTextCell_MouseLeave(object sender, System.EventArgs e)
        {
            this.BackColor = Color.FromArgb(0x000000FF);
        }
    }

    
}
