﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using DevComponents.DotNetBar.Ribbon;
using DevComponents.DotNetBar.Controls;

namespace MathTextBox
{
    public partial class MathStatment : TableLayoutPanel
    {
        public int items = 0;
        public List<MathTextManager> TextManagers = new List<MathTextManager>();
        public MathStatment()
        {
            TextManagers = new List<MathTextManager>();
            this.RowStyles.Clear();
            InitializeComponent();
            
        }

        protected override void OnPaint(PaintEventArgs pe)
        {
            base.OnPaint(pe);
        }

        public void AddNewCell()
        {
            //TextManagers = new List<MathTextManager>();
            MathTextCell MTC1 = new MathTextCell();
            MathTextManager  MTM = new MathTextManager(MTC1);
            MTM.Parent = this;
            MTM.Index = items;
            this.RowStyles.Add(new RowStyle(SizeType.AutoSize,45));
            this.Controls.Add(MTC1);
            MTC1.Location = new Point(10, 0);
            MTC1.MaximumSize= new Size(0,0);
            MTC1.TabIndex = 0;
            MTC1.TabStop = true;
            MTM.ActiveTextBox.Focus();
            MTC1.Anchor = AnchorStyles.Left ;
            TextManagers.Add(MTM);
            items += 1;



            if(this.AnswerChanged != null)
                this.AnswerChanged(this, new EventArgs());
            
        }
        private void MathStatment_Click(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            //AddNewCell();
           
        }
        private void MathStatment_HandleCreated(object sender, System.EventArgs e)
        {
            AddNewCell();
        }
        public void ScrollToSelected(Control c1)
        {

            this.ScrollControlIntoView(c1);

        }
        private void MathStatment_Scroll(object sender, System.Windows.Forms.ScrollEventArgs e)
        {
            
        }
        public void onAnsweChanged()
        {
            for(int i=0; i < TextManagers.Count; i++)
            {
                RowStyles[i].Height = TextManagers[i].TextView.Height;
            }
            this.AnswerChanged(this,new EventArgs());
        }
        public void onFocusedItemChanged()
        {
            foreach (MathTextManager MTM in TextManagers)
            {
                if (MTM.IsActive)
                {
                    

                    this.ScrollControlIntoView(MTM.ActiveTextBox);



                    //Point P1 = MTM.TextView.FindForm().PointToClient(MTM.TextView.Parent.PointToScreen(MTM.TextView.Location));
                    //Point P = MTM.ActiveTextBox.FindForm().PointToClient(MTM.ActiveTextBox.Parent.PointToScreen(MTM.ActiveTextBox.Location));
                    
                }
            }
        }
        public void IAmActive(int index)
        {
            foreach(MathTextManager TM in TextManagers)
            {
                if(TM.Index == index)
                {
                    TM.IsActive = true;
                }
                else
                {
                    TM.IsActive = false;
                }
            }
        }
        //events
        public event EventHandler AnswerChanged;
    }
}
