﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MathTextBox
{
    
    public partial class Form1 : Form
    {
        Point P = new Point(0, 0);
        Boolean move = false;
        public Form1()
        {
            InitializeComponent();
        }

        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams CP = base.CreateParams;
                CP.ExStyle = CP.ExStyle | 0x02000000;
                return CP;
            }
        }

        
        

        private void Form1_Load(object sender, EventArgs e)
        {
            statmentWithAnswer1.mathStatment.TextManagers[0].ActiveTextBox.Select();
        }

        private void RI_Mouse_Enter(object sender, EventArgs e)
        {
            ((DevComponents.DotNetBar.Controls.ReflectionImage)sender).ReflectionEnabled = true;
        }

        private void RI_Mouse_Leave(object sender, EventArgs e)
        {
            ((DevComponents.DotNetBar.Controls.ReflectionImage)sender).ReflectionEnabled = false;
        }

        private void reflectionImage1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void reflectionImage2_Click(object sender, EventArgs e)
        {
            WindowState = FormWindowState.Minimized;
        }

        private void Numbers_Mouse_Enter(object sender, EventArgs e)
        {
            ((DevComponents.DotNetBar.ButtonX)sender).ForeColor = Color.Black;
        }

        private void Numbers_Mouse_Leave(object sender, EventArgs e)
        {
            ((DevComponents.DotNetBar.ButtonX)sender).ForeColor = Color.White;
        }

        private void buttonX19_Click(object sender, EventArgs e)
        {
            
            string S ="";
            foreach(MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    S += Translator.Translate(MTM.Cells, 0);
                    
                }
            }
            if (S != "")
            {
                Clipboard.GetText(TextDataFormat.Text);
                Clipboard.SetText(S);
            }

        }

        private void buttonX21_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.onClear();
                    MTM.ActiveTextBox.Focus();
                }
            }
        }

        private void DFBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onCompareOrDefine(((DevComponents.DotNetBar.ButtonX)sender).Tag.ToString());

                }
            }
        }

        private void Numbers_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.setText(((DevComponents.DotNetBar.ButtonX)sender).Tag.ToString());

                }
            }
        }

        private void Operators_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onOperator((((DevComponents.DotNetBar.ButtonX)sender).Tag.ToString())[0]);

                }
            }
        }

        private void RepeatBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onRepeat();

                }
            }
        }

        private void EndBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onEnd();

                }
            }
        }

        private void NextLineBtn_Click(object sender, EventArgs e)
        {
            statmentWithAnswer1.mathStatment.AddNewCell();
        }

        private void ConstEBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onLetter("e");

                }
            }
        }

        private void PiBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onLetter("pi");

                }
            }
        }

        private void IBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onLetter("i");

                }
            }
        }

        private void FPBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onSParanthes();

                }
            }
        }

        private void SqrtBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onFunction1Arc("Sqrt");

                }
            }
        }

        private void ExpBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onFunction1Arc("Exp");

                }
            }
        }

        private void LnBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onFunction1Arc("Ln");

                }
            }
        }

        private void setArcHyp()
        {
            bool HypActive = HypBtn.Checked, ArcActive = ArcBtn.Checked;
            if (HypActive & ArcActive)
            {
                SinBtn.Text = "ASinh";
                CosBtn.Text = "ACosh";
                TanBtn.Text = "ATanh";
                CotBtn.Text = "ACoth";
                CscBtn.Text = "ACsch";
                SecBtn.Text = "ASech";
            }
            else if (!HypActive & ArcActive)
            {
                SinBtn.Text = "ASin";
                CosBtn.Text = "ACos";
                TanBtn.Text = "ATan";
                CotBtn.Text = "ACot";
                CscBtn.Text = "ACsc";
                SecBtn.Text = "ASec";
            }
            else if (HypActive & !ArcActive)
            {
                SinBtn.Text = "Sinh";
                CosBtn.Text = "Cosh";
                TanBtn.Text = "Tanh";
                CotBtn.Text = "Coth";
                CscBtn.Text = "Csch";
                SecBtn.Text = "Sech";
            }
            else
            {
                SinBtn.Text = "Sin";
                CosBtn.Text = "Cos";
                TanBtn.Text = "Tan";
                CotBtn.Text = "Cot";
                CscBtn.Text = "Csc";
                SecBtn.Text = "Sec";
            }
        }

        private void ArcBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    ArcBtn.Checked = !ArcBtn.Checked;

                }
            }
            setArcHyp();
            
        }

        private void HypBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    HypBtn.Checked = !HypBtn.Checked;

                }
            }
            setArcHyp();
            
        }

        private void Trigo_Btn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onFunction1Arc(((DevComponents.DotNetBar.ButtonX)sender).Text);

                }
            }
        }

        private void GP2_DragOver(object sender, DragEventArgs e)
        {

        }

        private void GP2_MouseDown(object sender, MouseEventArgs e)
        {
            Point P1 = this.PointToScreen(e.Location);
            P.X = P1.X;
            P.Y = P1.Y;
            Top_pnl.Cursor = Cursors.Cross;
            move = true;
        }

        private void GP2_MouseMove(object sender, MouseEventArgs e)
        {
            if (move)
            {
                Point P1 = this.PointToScreen(e.Location);
                this.Location = new Point(this.Location.X + (P1.X - P.X), this.Location.Y + (P1.Y - P.Y));

                P.X = P1.X;
                P.Y = P1.Y;
            }
        }

        private void GP2_MouseUp(object sender, MouseEventArgs e)
        {
            Top_pnl.Cursor = Cursors.Arrow;
            move = false;
        }
        
        private void buttonX20_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    
                    MTM.onCE();
                    MTM.ActiveTextBox.Focus();
                }
            }
        }

        private void PowerBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onFunction2Arc("Pow");

                }
            }
        }

        private void Power2Btn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.Pow2("Pow",2.ToString());

                }
            }
        }

        private void LogBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.Pow2("Log",  " ");

                }
            }
        }

        private void CommaBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.comma();

                }
            }
        }

        private void FactBtn_Click(object sender, EventArgs e)
        {
            foreach (MathTextManager MTM in statmentWithAnswer1.mathStatment.TextManagers)
            {
                if (MTM.IsActive)
                {
                    MTM.ActiveTextBox.Focus();
                    MTM.onFunction1Arc("Factorial");

                }
            }
        }

        private void Exit_btn_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Minimize_btn_Click(object sender, EventArgs e)
        {
            this.WindowState = System.Windows.Forms.FormWindowState.Minimized;
        }
    }
}
